/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.UnorderedPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.SemiGraph;
import nuts.util.CollUtils;
import nuts.util.Tree;

public class HashGraph<V>
implements Graph<V> {
    private final Set<UnorderedPair<V, V>> edges;
    private final Set<V> vertices;
    private final Map<V, Set<V>> nbrs;

    public HashGraph(Graph<V> model) {
        this.vertices = CollUtils.archive(model.vertexSet());
        this.edges = new HashSet<UnorderedPair<V, V>>();
        this.nbrs = new HashMap<V, Set<V>>();
        this.populate(model);
    }

    public HashGraph(Tree<V> tree) {
        if (!Graphs.treeHasUniqueNodes(tree)) {
            throw new RuntimeException();
        }
        this.vertices = HashGraph.vertices(tree);
        this.edges = HashGraph.edges(tree);
        this.nbrs = this.nbrs(this.vertices, this.edges);
    }

    public HashGraph(SemiGraph<V> semiGraph) {
        this.vertices = CollUtils.archive(semiGraph.vertexSet());
        this.edges = HashGraph.edges(this.vertices, semiGraph);
        this.nbrs = this.nbrs(this.vertices, this.edges);
    }

    public HashGraph(Set<V> vertices, Set<UnorderedPair<V, V>> edges) {
        this.vertices = CollUtils.archive(vertices);
        this.edges = CollUtils.archive(edges);
        this.nbrs = this.nbrs(vertices, edges);
    }

    public HashGraph(Set<UnorderedPair<V, V>> edges) {
        this(HashGraph.verticesInEdge(edges), edges);
    }

    public static <V> Set<V> verticesInEdge(Set<UnorderedPair<V, V>> edges) {
        HashSet<V> vertices = new HashSet<V>();
        for (UnorderedPair<V, V> edge : edges) {
            vertices.add(edge.getFirst());
            vertices.add(edge.getSecond());
        }
        return vertices;
    }

    private static <V> Set<UnorderedPair<V, V>> edges(Set<V> vertexSet, SemiGraph<V> semiGraph) {
        HashSet<UnorderedPair<V, V>> result = new HashSet<UnorderedPair<V, V>>();
        for (V v : vertexSet) {
            for (V w : vertexSet) {
                if (!semiGraph.hasSemiEdge(v, w)) continue;
                result.add(new UnorderedPair<V, V>(v, w));
            }
        }
        return result;
    }

    private Map<V, Set<V>> nbrs(Set<V> vertices, Set<UnorderedPair<V, V>> edges) {
        HashMap result = new HashMap();
        for (V v : vertices) {
            result.put(v, new HashSet());
        }
        for (UnorderedPair unorderedPair : edges) {
            Object v = unorderedPair.getFirst();
            Object w = unorderedPair.getSecond();
            if (!vertices.contains(v) || !vertices.contains(w)) {
                throw new RuntimeException();
            }
            this.add(result, v, w);
            this.add(result, w, v);
        }
        return result;
    }

    private void add(Map<V, Set<V>> result, V v, V w) {
        Set<V> current = result.get(v);
        current.add(w);
    }

    private static <V> Set<V> vertices(Tree<V> tree) {
        HashSet<V> result = new HashSet<V>();
        for (Tree<V> subt : tree.getPostOrderTraversal()) {
            result.add(subt.getLabel());
        }
        return result;
    }

    private static <V> Set<UnorderedPair<V, V>> edges(Tree<V> tree) {
        HashSet<UnorderedPair<V, V>> result = new HashSet<UnorderedPair<V, V>>();
        for (Tree<V> subt : tree.getPreOrderTraversal()) {
            for (Tree<V> child : subt.getChildren()) {
                result.add(new UnorderedPair<V, V>(subt.getLabel(), child.getLabel()));
            }
        }
        return result;
    }

    private void populate(Graph<V> model) {
        for (V v1 : model.vertexSet()) {
            Set<V> cur = model.nbrs(v1);
            this.nbrs.put((Set<V>)v1, (Set<Set<V>>)cur);
            for (V v2 : cur) {
                this.edges.add(this.key(v1, v2));
            }
        }
    }

    @Override
    public boolean hasEdge(V node1, V node2) {
        this.check(node1);
        this.check(node2);
        return this.edges.contains(this.key(node1, node2));
    }

    @Override
    public Set<V> nbrs(V node) {
        this.check(node);
        Set<V> _nbrs = this.nbrs.get(node);
        if (_nbrs == null) {
            throw new RuntimeException();
        }
        return Collections.unmodifiableSet(_nbrs);
    }

    @Override
    public Set<V> vertexSet() {
        return Collections.unmodifiableSet(this.vertices);
    }

    private UnorderedPair<V, V> key(V first, V second) {
        return new UnorderedPair<V, V>(first, second);
    }

    private void check(V node) {
        if (!this.vertices.contains(node)) {
            throw new RuntimeException("Node not found:" + node);
        }
    }
}

