/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.IOUtils;
import fig.basic.Option;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.Plot2D;

public class PlotHistogram {
    public List<Double> points = new ArrayList<Double>();
    @Option
    public String rPath = "r";
    private double lineWidth = 6.0;

    public void addPoints(List<Double> _points) {
        this.points.addAll(_points);
    }

    public void addPoint(double d) {
        this.points.add(d);
    }

    public void savePlot(File outputPDFFile) {
        File tempDir = IO.getTempDir("r-temp");
        File rScriptFile = new File(tempDir, "script.r");
        PrintWriter rscript = IOUtils.openOutEasy(rScriptFile);
        rscript.println("pdf('" + Plot2D.escapeQuote(outputPDFFile.getAbsolutePath()) + "')");
        rscript.println("par(ps=30)");
        File curFile = new File(tempDir, "dataset.csv");
        PlotHistogram.writeCSVToFile(curFile, this.points);
        rscript.println("data  <- read.table('" + Plot2D.escapeQuote(curFile.getAbsolutePath()) + "',sep=',')");
        rscript.println("hist(data$V1, breaks=\"FD\",ann=FALSE,probability=TRUE, col=\"gray\", border=\"white\")");
        rscript.println("d <- density(data$V1)");
        rscript.println("lines(d, col=\"red\", lwd=" + this.lineWidth + ")");
        rscript.println("rug(data$V1, col=\"red\")");
        rscript.println("dev.off()");
        rscript.close();
        File rOut = new File(tempDir, "rOut");
        IO.call("" + this.rPath + " CMD BATCH " + rScriptFile.getName() + " " + rOut.getName(), null, tempDir);
    }

    public static void writeCSVToFile(File f, List<Double> series) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (double item : series) {
            out.println(CSV.body(item));
        }
        out.close();
    }

    public static void main(String[] args) {
        PlotHistogram h = new PlotHistogram();
        Random rand = new Random(1L);
        for (int i = 0; i < 500; ++i) {
            h.points.add(rand.nextGaussian());
        }
        h.savePlot(new File("/Users/bouchard/temp/hist.pdf"));
    }
}

