/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import java.util.Map;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class StatisticsMap<K> {
    private final Map<K, SummaryStatistics> map = CollUtils.map();

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public SummaryStatistics getSummaryStat(K key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new SummaryStatistics());
        }
        return this.map.get(key);
    }

    public void addValue(K key, double value) {
        this.getSummaryStat(key).addValue(value);
    }

    public boolean matchingSizes() {
        long n = -1L;
        for (SummaryStatistics stat : this.map.values()) {
            if (n == -1L) {
                n = stat.getN();
                continue;
            }
            if (n == stat.getN()) continue;
            return false;
        }
        return true;
    }

    public double mean(K key) {
        return this.getSummaryStat(key).getMean();
    }

    public Counter<K> means() {
        Counter<K> result = new Counter<K>();
        for (K key : this.map.keySet()) {
            result.setCount(key, this.mean(key));
        }
        return result;
    }

    public String printAll() {
        StringBuilder result = new StringBuilder();
        for (K key : CollUtils.orderWithToString(this.map.keySet())) {
            result.append("" + key + "\t" + this.map.get(key) + "\n");
        }
        return result.toString();
    }

    public String toString() {
        return CollUtils.counter2StringWithSortedKeys(this.means());
    }

    public static class DescriptiveStatisticsMap<K>
    extends StatisticsMap<K> {
        public final Map<K, DescriptiveStatistics> dmap = CollUtils.map();

        @Override
        public void addValue(K key, double value) {
            super.addValue(key, value);
            this.getDescriptiveStat(key).addValue(value);
        }

        public DescriptiveStatistics getDescriptiveStat(K key) {
            if (!this.dmap.containsKey(key)) {
                this.dmap.put(key, new DescriptiveStatistics());
            }
            return this.dmap.get(key);
        }

        public Counter<K> medians() {
            return this.percentiles(0.5);
        }

        public double median(K key) {
            return this.percentile(key, 0.5);
        }

        public double percentile(K key, double fraction) {
            if (fraction < 0.0 || fraction > 1.0) {
                throw new RuntimeException();
            }
            return this.getDescriptiveStat(key).getPercentile(fraction * 100.0);
        }

        public Counter<K> percentiles(double fraction) {
            Counter<K> result = new Counter<K>();
            for (K key : this.dmap.keySet()) {
                result.setCount(key, this.percentile(key, fraction));
            }
            return result;
        }
    }
}

