/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.LogInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import nuts.util.Counter;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.ConstrainedEditMDParametrization;
import pepper.editmodel.EditParam;
import pepper.editmodel.EditSampler;
import pepper.editmodel.ParamUpdater;

public class MultiDiriParamUpdater
implements ParamUpdater.LanguageSpecificParamUpdater {
    private static final long serialVersionUID = 1L;
    private final Encodings enc;
    private EditSampler editSampler;
    private Set<Edit> allowedRules;
    private final double alpha_id;
    private final double alpha_edit;
    private final boolean projected;
    private final Random rand;

    public MultiDiriParamUpdater(Encodings enc, Random rand, Collection<Edit> rules, double alpha_id, double alpha_edit, boolean projected) {
        this.enc = enc;
        this.alpha_id = alpha_id;
        this.alpha_edit = alpha_edit;
        this.projected = projected;
        this.rand = rand;
        this.allowedRules = new HashSet<Edit>();
        this.allowedRules.addAll(rules);
        ArrayList<Edit> rulesList = new ArrayList<Edit>();
        rulesList.addAll(rules);
        ConstrainedEditMDParametrization param = new ConstrainedEditMDParametrization(enc, rulesList, alpha_id, alpha_edit, projected);
        this.editSampler = new EditSampler(rand, param);
    }

    @Override
    public Encodings getEncodings() {
        return this.enc;
    }

    @Override
    public void setSparsityStructure(Set<Edit> rules) {
        this.allowedRules = new HashSet<Edit>();
        this.allowedRules.addAll(rules);
    }

    @Override
    public Set<Edit> getSparsityStructure() {
        return Collections.unmodifiableSet(this.allowedRules);
    }

    @Override
    public EditParam update(Counter<Edit> expectedEditCounts, boolean viterbi) {
        LogInfo.logss("Updating parameters using Dirichlet prior (sampling?" + !viterbi + ")");
        if (expectedEditCounts == null) {
            return this.editSampler.sample().getEditParameters();
        }
        return this.editSampler.sample(expectedEditCounts, viterbi).getEditParameters();
    }

    public String toString() {
        return "Multinomial-Dirichlet Model";
    }

    @Override
    public ParamUpdater.LanguageSpecificParamUpdater newInstance() {
        return new MultiDiriParamUpdater(this.enc, this.rand, this.allowedRules, this.alpha_id, this.alpha_edit, this.projected);
    }
}

