/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.models;

import fig.basic.Pair;
import nuts.math.TrapezoidLogSpaceIntegrator;
import nuts.maxent.SloppyMath;
import nuts.util.MathUtils;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.ContinuedFraction;

public final class VarianceMarginalUtils {
    public static final double TOL = 1.0E-10;
    public static final int MAX_ITERS = 100000;

    public static double logModifiedBesselSecondKind(double p, double z) {
        double pMinusOneHalf = Math.abs(p) - 0.5;
        if ((double)MathUtils.nint(pMinusOneHalf) - pMinusOneHalf > 0.0) {
            throw new RuntimeException();
        }
        int n = (int)pMinusOneHalf;
        double base = 0.5 * Math.log(1.5707963267948966) - z - 0.5 * Math.log(z);
        double sum = Double.NEGATIVE_INFINITY;
        for (int j = 0; j <= n; ++j) {
            sum = SloppyMath.logAdd(sum, MathUtils.logFactorial(j + n) - (double)j * Math.log(2.0 * z) - MathUtils.logFactorial(j) - MathUtils.logFactorial(n - j));
        }
        return base + sum;
    }

    public static double analyticGIGLogNormalization(double p, double a, double b) {
        return Math.log(2.0) + VarianceMarginalUtils.logModifiedBesselSecondKind(p, Math.sqrt(a * b)) - p / 2.0 * Math.log(a / b);
    }

    public static Pair<Double, Double> meanAndVarOfGIG(double p, double a, double b) {
        double sqrtab = Math.sqrt(a * b);
        double logKp = VarianceMarginalUtils.logModifiedBesselSecondKind(p, sqrtab);
        double logKpp1 = VarianceMarginalUtils.logModifiedBesselSecondKind(p + 1.0, sqrtab);
        double logKpp2 = VarianceMarginalUtils.logModifiedBesselSecondKind(p + 2.0, sqrtab);
        double mean = Math.sqrt(b) / Math.sqrt(a) * Math.exp(logKpp1 - logKp);
        double vart2 = Math.exp(logKpp1 - logKp);
        double var = b / a * (Math.exp(logKpp2 - logKp) - vart2 * vart2);
        return Pair.makePair(mean, var);
    }

    public static double truncatedGIGLogNormalizationApprox(double p, double a, double b, double lowerIntegrand) {
        System.out.println("tgiglna(" + p + "," + a + "," + b + "," + lowerIntegrand + ")");
        if (lowerIntegrand == 0.0) {
            return VarianceMarginalUtils.analyticGIGLogNormalization(p, a, b);
        }
        Pair<Double, Double> meanVar = VarianceMarginalUtils.meanAndVarOfGIG(p, a, b);
        double theta = meanVar.getSecond() / meanVar.getFirst();
        double kParam = meanVar.getFirst() / theta;
        try {
            return VarianceMarginalUtils.analyticGIGLogNormalization(p, a, b) + VarianceMarginalUtils.logRegularizedGammaQ(kParam, lowerIntegrand / theta);
        }
        catch (MathException e) {
            throw new RuntimeException(e);
        }
    }

    public static void testGIGNorm(double p, double a, double b, double trunc) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        System.out.println("Gamma approx log norm  :" + VarianceMarginalUtils.truncatedGIGLogNormalizationApprox(p, a, b, trunc));
        System.out.println("Numeric approx log norm:" + new TrapezoidLogSpaceIntegrator(new GIGlogDensity(p, a, b)).integrate(trunc, 100.0));
    }

    public static void main(String[] args) throws Exception {
        double s = 5.0;
        double x = 10.0;
        for (int i = 0; i < 1000; ++i) {
            System.out.println("x=" + x + ",cur:" + VarianceMarginalUtils.logRegularizedGammaQ(s, x));
            x *= 0.5;
        }
    }

    public static double logRegularizedGammaQ(double a, double x) throws MathException {
        return VarianceMarginalUtils.logRegularizedGammaQ(a, x, 1.0E-10, Integer.MAX_VALUE);
    }

    public static double logRegularizedGammaQ(final double a, double x, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else {
            ContinuedFraction cf = new ContinuedFraction(){
                private static final long serialVersionUID = 5378525034886164398L;

                protected double getA(int n, double x) {
                    return 2.0 * (double)n + 1.0 - a + x;
                }

                protected double getB(int n, double x) {
                    return (double)n * (a - (double)n);
                }
            };
            ret = -Math.log(cf.evaluate(x, epsilon, maxIterations));
            ret = -x + a * Math.log(x) - Gamma.logGamma((double)a) + ret;
        }
        return ret;
    }

    public static class GIGlogDensity
    implements UnivariateRealFunction {
        private final double p;
        private final double a;
        private final double b;

        public GIGlogDensity(double p, double a, double b) {
            this.p = p;
            this.a = a;
            this.b = b;
        }

        public double value(double x) throws FunctionEvaluationException {
            if (x <= 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return (this.p - 1.0) * Math.log(x) + -(this.a * x + this.b / x) / 2.0;
        }
    }
}

