/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.newick.NewickParser;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.Tree;

public class GenerateFromTree
implements Runnable {
    @Option
    public Random rand = new Random(1L);
    @Option
    public double scale = 0.001;
    @Option
    public double root = 0.5;
    @Option
    public int nsites = 10000;
    @Option(required=true)
    public String treeFile = "";
    public int fixed = 0;

    public File generate() {
        LogInfo.logsForce("Scale=" + this.scale);
        LogInfo.logsForce("Root=" + this.root);
        LogInfo.logsForce("nSites=" + this.nsites);
        LogInfo.logsForce("Tree=" + this.treeFile);
        try {
            NewickParser np = new NewickParser(IOUtils.openIn(this.treeFile));
            Tree<String> tree = np.parse();
            Arbre<String> ar = Arbre.tree2Arbre(tree);
            HashMap<Arbre<String>, double[]> node2sequenceMap = new HashMap<Arbre<String>, double[]>();
            Map<Taxon, Double> branchLengths = np.getBranchLengths();
            LogInfo.logsForce(ar.deepToString());
            File result = new File(Execution.getFile("simulated.txt"));
            PrintWriter bw = IOUtils.openOutHard(result);
            List<Arbre<String>> preorder = ar.nodes();
            for (Arbre<String> node : preorder) {
                int i;
                LogInfo.logsForce("Examining node:" + node.getContents());
                double[] tmp = new double[this.nsites];
                if (node.isRoot()) {
                    for (i = 0; i < this.nsites; ++i) {
                        tmp[i] = this.root;
                    }
                } else {
                    double[] parentsequence = (double[])node2sequenceMap.get(node.getParent());
                    double bl = branchLengths.get(new Taxon(node.getContents()));
                    LogInfo.logsForce("Branch length = " + bl);
                    LogInfo.logsForce("Parent = " + node.getParent());
                    for (int i2 = 0; i2 < this.nsites; ++i2) {
                        tmp[i2] = this.fix(parentsequence[i2] + this.rand.nextGaussian() * Math.sqrt(this.scale * bl));
                    }
                }
                if (node.isLeaf()) {
                    bw.write(node.getContents() + "\t");
                    for (i = 0; i < this.nsites; ++i) {
                        bw.write(tmp[i] + "\t");
                    }
                    bw.write("\n");
                }
                node2sequenceMap.put(node, tmp);
            }
            bw.close();
            LogInfo.logsForce("Fixed " + this.fixed + " sites");
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private double fix(double d) {
        if (d < 0.0) {
            ++this.fixed;
            return 0.0;
        }
        if (d > 1.0) {
            ++this.fixed;
            return 1.0;
        }
        return d;
    }

    public static void printArray(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            System.out.print(x[i] + " \t");
        }
        System.out.print("\n");
    }

    public static void main(String[] args) {
        IO.run(args, new GenerateFromTree());
    }

    @Override
    public void run() {
        this.generate();
    }
}

