/*
 * Decompiled with CFR 0.152.
 */
package slice.likelihood;

import fig.prob.Gaussian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.util.EasyFormat;
import slice.stickrep.Location;

public class NormalLocation
implements Location<List<Double>> {
    private List<Double> mean;
    private List<Double> var;

    public NormalLocation(List<Double> mean, List<Double> var) {
        this.mean = mean;
        this.var = var;
    }

    @Override
    public double unnormLoglikelihood(List<Double> x) {
        double sum = 0.0;
        for (int d = 0; d < this.dim(); ++d) {
            sum += Gaussian.logProb((double)this.mean.get(d), (double)this.var.get(d), x.get(d));
        }
        return sum;
    }

    public int dim() {
        return this.mean.size();
    }

    @Override
    public List<Double> sample(Random rand) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < this.dim(); ++i) {
            result.add(Gaussian.sample(rand, this.mean.get(i), this.var.get(i)));
        }
        return result;
    }

    public String toString() {
        return "N(" + EasyFormat.fmt(this.mean) + ", " + EasyFormat.fmt(this.var) + ")";
    }

    public List<Double> getMean() {
        return Collections.unmodifiableList(this.mean);
    }

    public List<Double> getVar() {
        return Collections.unmodifiableList(this.var);
    }
}

