/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.exec.Execution;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import java.util.regex.Pattern;

public class WeightCommunication {
    public static String currentExecPath = new File(Execution.getVirtualExecDir()).getAbsolutePath();
    public static String commDirPath;
    public static int numNodes;
    public static int defaultWaitingTime;

    public static void createCommFolder() {
        File commDir = new File(commDirPath);
        commDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSeeds(int[] seeds) {
        File seedsDoneFile = new File(commDirPath + "/seeds.file.done");
        while (!seedsDoneFile.exists()) {
        }
        File seedsFile = new File(commDirPath + "/seeds.file");
        try (Scanner seedsScanner = null;){
            seedsScanner = new Scanner(seedsFile);
            int counter = 0;
            while (seedsScanner.hasNextInt()) {
                seeds[counter] = seedsScanner.nextInt();
                ++counter;
            }
        }
    }

    public static void writeSeeds(int[] seeds) throws IOException {
        File seedsFile = new File(commDirPath + "/seeds.file");
        if (seedsFile.exists()) {
            LogInfo.logs("Unrecoverable error: seeds.file already exists");
            System.exit(-1);
        }
        seedsFile.createNewFile();
        FileWriter fwriter = new FileWriter(seedsFile);
        for (int i = 0; i < seeds.length; ++i) {
            fwriter.write(seeds[i] + "\n");
        }
        fwriter.close();
        File seedsDoneFile = new File(commDirPath + "/seeds.file.done");
        if (seedsDoneFile.exists()) {
            LogInfo.logs("Unrecoverable error: seeds.file.done already exists");
            System.exit(-1);
        }
        seedsDoneFile.createNewFile();
    }

    public static double readWeights(int t, int myId, int targetId, int start, double[] weights) throws WeightTimeoutException, IOException {
        File weightFile = null;
        File weightDoneFile = null;
        Scanner weightScanner = null;
        double norm = 0.0;
        double w = 0.0;
        int counter = start;
        weightDoneFile = new File(commDirPath + "/weights." + targetId + "." + t + ".done.file");
        long startTime = System.currentTimeMillis();
        while (!weightDoneFile.exists()) {
            long endTime = System.currentTimeMillis();
            if ((endTime - startTime) / 1000L < (long)defaultWaitingTime) continue;
            throw new WeightTimeoutException(myId, targetId, t);
        }
        weightFile = new File(commDirPath + "/weights." + targetId + "." + t + ".file");
        weightScanner = new Scanner(weightFile);
        while (weightScanner.hasNextDouble()) {
            w = weightScanner.nextDouble();
            weights[counter++] = w;
            norm += w;
        }
        weightScanner.close();
        return norm;
    }

    public static double writeWeights(double[] weights, int t, int myId) throws IOException {
        File weightFile = new File(commDirPath + "/weights." + myId + "." + t + ".file");
        if (weightFile.exists()) {
            LogInfo.logs("Unrecoverable error: weight file already exists for machine=" + myId + " at time t=" + t);
            System.exit(-1);
        }
        weightFile.createNewFile();
        FileWriter fwriter = new FileWriter(weightFile);
        double norm = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            fwriter.write(weights[i] + "\n");
            norm += weights[i];
        }
        fwriter.close();
        File weightsDoneFile = new File(commDirPath + "/weights." + myId + "." + t + ".done.file");
        if (weightsDoneFile.exists()) {
            LogInfo.logs("Unrecoverable error: weights." + myId + "." + t + ".done.file already exists");
            System.exit(-1);
        }
        weightsDoneFile.createNewFile();
        return norm;
    }

    static {
        numNodes = -1;
        defaultWaitingTime = 600;
        commDirPath = currentExecPath.replaceFirst(Pattern.compile("seg[0-9]+.*$").pattern(), "comm");
        LogInfo.logs("comm dir=" + commDirPath);
    }

    public static class WeightTimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int targetMachineId;
        private int sourceMachineId;
        private int t;

        public WeightTimeoutException(int sourceMachineId, int targetMachineId, int t) {
            super("Maximum wait time passed: source=" + sourceMachineId + " target=" + targetMachineId + " at t=" + t);
            this.sourceMachineId = sourceMachineId;
            this.targetMachineId = targetMachineId;
            this.t = t;
        }

        public int getSourceMachineId() {
            return this.sourceMachineId;
        }

        public int getTargetMachineId() {
            return this.targetMachineId;
        }

        public int getTime() {
            return this.t;
        }
    }
}

