/*
 * Decompiled with CFR 0.152.
 */
package stat547c;

import fig.basic.NumUtils;
import fig.basic.Option;
import fig.prob.SampleUtils;
import gep.util.OutputManager;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.math.Graphs;
import nuts.util.CollUtils;

public class Ising {
    private final Graphs.Grid graph;
    private final double[][] symmetricPairPotential;
    private final double[][] nodePotential;
    private final List<Integer> permutation;
    private final int nValues;
    private final int nVariables;
    private double nMCMCSteps = 0.0;
    private OutputManager outMan = new OutputManager();

    public static double[][] uniformNodePotential(int nVariables, int nValues) {
        double[][] result = new double[nVariables][nValues];
        for (int i = 0; i < nVariables; ++i) {
            for (int j = 0; j < nValues; ++j) {
                result[i][j] = 1.0;
            }
        }
        return result;
    }

    public int[] randomInitState(Random rand) {
        int[] result = new int[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            result[i] = rand.nextInt(this.nValues);
        }
        return result;
    }

    public static double[][] agreementPairPotential(int nValues, double agree, double disagree) {
        double[][] result = new double[nValues][nValues];
        for (int i = 0; i < nValues; ++i) {
            for (int j = 0; j < nValues; ++j) {
                result[i][j] = i == j ? agree : disagree;
            }
        }
        return result;
    }

    public Ising(Graphs.Grid graph, double[][] symmetricPairPotential, double[][] nodePotential) {
        this.graph = graph;
        this.symmetricPairPotential = symmetricPairPotential;
        this.nodePotential = nodePotential;
        this.nValues = symmetricPairPotential.length;
        this.nVariables = graph.vertexSet().size();
        if (this.nVariables != nodePotential.length) {
            throw new RuntimeException();
        }
        this.permutation = CollUtils.list();
        for (int i = 0; i < this.nVariables; ++i) {
            this.permutation.add(i);
        }
    }

    public void gibbs(Random rand, int[] globalState, Integer targetVariable) {
        double[] prs = new double[this.nValues];
        for (int s = 0; s < this.nValues; ++s) {
            double prod = 1.0;
            prod *= this.nodePotential[targetVariable][s];
            for (Integer nhbr : this.graph.nbrs(targetVariable)) {
                prod *= this.symmetricPairPotential[s][globalState[nhbr]];
            }
            prs[s] = prod;
        }
        NumUtils.normalize(prs);
        globalState[targetVariable.intValue()] = SampleUtils.sampleMultinomial(rand, prs);
        this.collectStats(globalState);
    }

    private void collectStats(int[] globalState) {
        this.nMCMCSteps += 1.0;
    }

    public void gibbsScan(Random rand, int[] globalState) {
        Collections.shuffle(this.permutation, rand);
        for (Integer variable : this.permutation) {
            this.gibbs(rand, globalState, variable);
        }
    }

    public static class IsingMain
    implements Runnable {
        @Option
        public int L = 5;
        @Option
        public int D = 2;
        @Option
        public int nValues = 2;
        @Option
        public double agree = 5.0;
        @Option
        public double disagree = 1.0;
        @Option
        public Random rand = new Random(1L);
        @Option
        public int nIters = 10000;

        public static void main(String[] args) {
            IO.run(args, new IsingMain());
        }

        @Override
        public void run() {
            Graphs.Grid grid = Graphs.boundedGrid(this.D, this.L);
            Ising ising = new Ising(grid, Ising.agreementPairPotential(this.nValues, this.agree, this.disagree), Ising.uniformNodePotential(grid.vertexSet().size(), this.nValues));
            int[] initState = ising.randomInitState(this.rand);
            for (int iter = 0; iter < this.nIters; ++iter) {
                ising.gibbsScan(this.rand, initState);
            }
        }
    }
}

