/*
 * Decompiled with CFR 0.152.
 */
package times;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.util.Random;
import times.TreeState;
import times.mcmc;

public class TimeEstimate
implements Runnable {
    @Option
    public String treeFile = "newick.txt";
    @Option
    public String timeFile = "time.txt";
    @Option
    public String rateFile = "rate.txt";
    @Option
    public String ingroupFile = "ingroup.txt";
    @Option
    public int maxiters = 10000;
    @Option
    public int burnin = 100;
    public static final Random rand = new Random(1L);
    TreeState ts;

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new TimeEstimate());
    }

    @Override
    public void run() {
        this.ts = new TreeState(this.treeFile, this.timeFile, this.rateFile, this.ingroupFile);
        this.ts.init(rand);
        mcmc mc = new mcmc(this.ts, rand);
        for (int i = 0; i < this.burnin + this.maxiters; ++i) {
            TreeState currentState = (TreeState)mc.sample();
            LogInfo.logs("Iteration = " + i + "\t" + currentState);
        }
    }
}

