/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Annotation
implements PhylogenyData,
MultipleUris,
Comparable<Annotation> {
    private String _desc;
    private String _type;
    private String _source;
    private final String _ref;
    private String _evidence;
    private Confidence _confidence;
    private PropertiesMap _properties;
    private List<Uri> _uris;

    public Annotation(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to create Annotation with null or empty reference");
        }
        if (string.indexOf(58) < 1 || string.length() < 3) {
            throw new IllegalArgumentException("illegal format for Annotation reference: [" + string + "]");
        }
        this._ref = string;
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.getDesc());
    }

    @Override
    public PhylogenyData copy() {
        Annotation annotation = new Annotation(new String(this.getRef()));
        if (this.getConfidence() != null) {
            annotation.setConfidence((Confidence)this.getConfidence().copy());
        } else {
            annotation.setConfidence(null);
        }
        annotation.setType(new String(this.getType()));
        annotation.setDesc(new String(this.getDesc()));
        annotation.setEvidence(new String(this.getEvidence()));
        annotation.setSource(new String(this.getSource()));
        if (this.getProperties() != null) {
            annotation.setProperties((PropertiesMap)this.getProperties().copy());
        } else {
            annotation.setProperties(null);
        }
        if (this.getUris() != null) {
            annotation.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                annotation.getUris().add(uri);
            }
        }
        return annotation;
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getEvidence() {
        return this._evidence;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public String getRef() {
        return this._ref;
    }

    public String getSource() {
        return this._source;
    }

    public String getType() {
        return this._type;
    }

    private void init() {
        this._desc = "";
        this._type = "";
        this._source = "";
        this._evidence = "";
        this._confidence = null;
        this._properties = null;
        this.setUris(null);
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        Annotation annotation = (Annotation)phylogenyData;
        return this.getDesc().equalsIgnoreCase(annotation.getDesc()) && this.getType().equals(annotation.getType()) && this.getSource().equals(annotation.getSource()) && this.getRef().equals(annotation.getRef());
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDesc(String string) {
        this._desc = string;
    }

    public void setEvidence(String string) {
        this._evidence = string;
    }

    public void setProperties(PropertiesMap propertiesMap) {
        this._properties = propertiesMap;
    }

    public void setSource(String string) {
        this._source = string;
    }

    public void setType(String string) {
        this._type = string;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getConfidence() != null || this.getProperties() != null || this.getUris() != null && !this.getUris().isEmpty() || !ForesterUtil.isEmpty(this.getDesc())) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendOpen(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource());
            if (!ForesterUtil.isEmpty(this.getDesc())) {
                PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), string);
            }
            if (this.getConfidence() != null) {
                this.getConfidence().toPhyloXML(writer, n, string + "  ");
            }
            if (this.getProperties() != null) {
                this.getProperties().toPhyloXML(writer, n, string);
            }
            if (this.getUris() != null) {
                for (Uri uri : this.getUris()) {
                    if (uri == null) continue;
                    uri.toPhyloXML(writer, n, string);
                }
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendClose(writer, "annotation");
        } else {
            PhylogenyDataUtil.appendElement(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public Uri getUri(int n) {
        return this.getUris().get(n);
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    @Override
    public void setUris(List<Uri> list) {
        this._uris = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Annotation)object);
    }

    @Override
    public int compareTo(Annotation annotation) {
        if (this.equals(annotation)) {
            return 0;
        }
        if (this.getRef().equals(annotation.getRef())) {
            return this.getDesc().compareTo(annotation.getDesc());
        }
        return this.getRef().compareTo(annotation.getRef());
    }
}

