/*
 * Decompiled with CFR 0.152.
 */
package conifer.clock.proposals;

import conifer.clock.ClockTree;
import conifer.clock.proposals.ClockTreeProposal;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;

public class SingleBranchLengthProposal
implements ClockTreeProposal {
    @Override
    public Pair<ClockTree, Double> propose(Random rand, ClockTree tree) {
        Counter<Set<Taxon>> internalHeights = tree.internalHeights();
        for (Set<Taxon> tax : CollUtils.set(internalHeights.keySet())) {
            if (tax.size() != tree.leaves().size()) continue;
            internalHeights.removeKey(tax);
        }
        Set<Taxon> selected = ClockTree.sample(internalHeights, rand);
        double max = tree.height(tree.parent(selected));
        double min = tree.height(tree.tallChild(selected));
        double newHeight = min + (max - min) * rand.nextDouble();
        HashMap<Set<Taxon>, Double> newHeights = CollUtils.map(tree.getHeights());
        newHeights.put(selected, newHeight);
        return Pair.makePair(new ClockTree(newHeights), 0.0);
    }

    @Override
    public String description() {
        return "SingleBranchLengthProposal";
    }
}

