/*
 * Decompiled with CFR 0.152.
 */
package conifer.data;

import conifer.Phylogeny;
import conifer.data.AlignedData;
import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import conifer.trees.TreeOptions;
import ev.io.PreprocessGutellData;
import java.io.File;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import ma.SequenceType;

public enum DataModel {
    GUTELL{

        @Override
        public PhylogeneticData loadDataset(DataOptions options) {
            MSAPoset msa = PreprocessGutellData.randomDataSet(new File(options.dataFile), 1, options.generatingTreeOptions.nTaxa, options.generatingEvolutionaryOptions.rand).get(0);
            msa.fixMSAUsingRandomCharacters(RateMatrixLoader.rnaIndexer().objects(), options.rand);
            return new PhylogeneticData(null, new AlignedData(msa, SequenceType.RNA), msa, null);
        }
    }
    ,
    GENERATED{

        @Override
        public PhylogeneticData loadDataset(DataOptions options) {
            EvolutionaryOptions evoOptions = options.generatingEvolutionaryOptions;
            EvolutionaryParameters params = evoOptions.model.instantiateParameters(evoOptions, null);
            TreeOptions treeOptions = options.generatingTreeOptions;
            Phylogeny p = treeOptions.model.sample(treeOptions);
            return params.generate(p);
        }
    };


    public abstract PhylogeneticData loadDataset(DataOptions var1);
}

