/*
 * Decompiled with CFR 0.152.
 */
package conifer.pip;

import goblin.Taxon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nuts.maxent.SloppyMath;
import nuts.util.Arbre;

public class PIPLikelihoodUtils {
    public static double[][] standardLogScaleFelsensteinRecursion(double[][] fels1, double[][] fels2, double[][] logPr1, double[][] logPr2) {
        int ns = fels1.length;
        if (fels2.length != ns) {
            throw new RuntimeException();
        }
        int ncs = logPr1.length;
        if (logPr1.length != ncs) {
            throw new RuntimeException();
        }
        for (double[][] item : new double[][][]{logPr1, logPr2}) {
            if (item[0].length == item.length) continue;
            throw new RuntimeException();
        }
        double[][] result = new double[ns][ncs];
        for (int s = 0; s < ns; ++s) {
            double[] curFHat1 = fels1[s];
            double[] curFHat2 = fels2[s];
            for (int v = 0; v < ncs; ++v) {
                double prod = 0.0;
                prod += PIPLikelihoodUtils.sum(logPr1[v], curFHat1);
                result[s][v] = prod += PIPLikelihoodUtils.sum(logPr2[v], curFHat2);
            }
        }
        return result;
    }

    private static double sum(double[] logPrs, double[] cacheAtLeaf) {
        double sum = Double.NEGATIVE_INFINITY;
        int ncs = logPrs.length;
        for (int w = 0; w < ncs; ++w) {
            sum = SloppyMath.logAdd(sum, logPrs[w] + cacheAtLeaf[w]);
        }
        return sum;
    }

    public static Map<Taxon, Taxon> extractChild(int i, Arbre<Taxon> topology) {
        HashMap<Taxon, Taxon> result = new HashMap<Taxon, Taxon>();
        block4: for (Arbre<Taxon> node : topology.nodes()) {
            List<Arbre<Taxon>> children = node.getChildren();
            switch (children.size()) {
                case 0: {
                    continue block4;
                }
                case 2: {
                    result.put(node.getContents(), children.get(i).getContents());
                    continue block4;
                }
            }
            throw new RuntimeException();
        }
        return result;
    }

    public static double totalTreeLength(Map<Taxon, Double> bls) {
        double sum = 0.0;
        for (Taxon t : bls.keySet()) {
            sum += bls.get(t).doubleValue();
        }
        return sum;
    }

    public static void fillPostOrder(List<Taxon> postOrderTaxaTraversal, Arbre<Taxon> topology) {
        for (Arbre<Taxon> child : topology.getChildren()) {
            PIPLikelihoodUtils.fillPostOrder(postOrderTaxaTraversal, child);
        }
        postOrderTaxaTraversal.add(topology.getContents());
    }
}

