/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.Edit;
import conifer.ssm.ForwardSimulator;
import conifer.ssm.InformedProposal2;
import conifer.ssm.StringMutationModel;
import conifer.ssm.Utils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.basic.Pair;
import gep.util.OutputManager;
import goblin.BayesRiskMinimizer;
import java.util.ArrayList;
import java.util.Random;
import nuts.io.IO;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class ReconstructionTest2
implements Runnable {
    @OptionSet(name="prop")
    public InformedProposal2 proposal = new InformedProposal2();
    @OptionSet(name="model")
    public StringMutationModel model = new StringMutationModel();
    @Option
    public Random dataGenRand = new Random(1L);
    @Option
    public Random inferenceRand = new Random(1L);
    @Option
    public double branchLengths = 0.2;
    @Option
    public int minIterations = 10;
    @Option
    public int maxIterations = 100;
    @Option
    public int nReplicates = 10;

    public static void main(String[] args) {
        IO.run(args, new ReconstructionTest2());
    }

    @Override
    public void run() {
        SummaryStatistics fractionBeat = new SummaryStatistics();
        for (int rep = 0; rep < this.nReplicates; ++rep) {
            LogInfo.track((Object)("GeneratingDataset " + rep), true);
            String start = ForwardSimulator.approxStationarySampling(this.model, this.dataGenRand);
            ArrayList<Edit> edits1 = new ArrayList<Edit>();
            ArrayList<Edit> edits2 = new ArrayList<Edit>();
            String bot1 = ForwardSimulator.next(start, this.model, this.branchLengths, this.dataGenRand, edits1);
            String bot2 = ForwardSimulator.next(start, this.model, this.branchLengths, this.dataGenRand, edits2);
            LogInfo.logs("Root\t" + start);
            LogInfo.track((Object)"Branch1", true);
            LogInfo.logs(Utils.toAlign(start, edits1));
            LogInfo.logs("dist\t" + BayesRiskMinimizer.levenshteinLoss.loss(bot1, start));
            LogInfo.end_track();
            LogInfo.track((Object)"Branch2", true);
            LogInfo.logs(Utils.toAlign(start, edits2));
            LogInfo.logs("dist\t" + BayesRiskMinimizer.levenshteinLoss.loss(bot2, start));
            LogInfo.end_track();
            LogInfo.end_track();
            LogInfo.track((Object)"Inference", true);
            OutputManager output = new OutputManager();
            InformedProposal2 p = this.proposal;
            p.setModel(this.model);
            for (int K = this.minIterations; K < this.maxIterations; K *= 2) {
                LogInfo.track((Object)("nParticles\t" + K), true);
                Counter<String> samples = new Counter<String>();
                Counter fromPrev = new Counter();
                for (int k = 0; k < K; ++k) {
                    Pair<String, Double> sample = p.proposeAndGetLogProb(this.inferenceRand, bot1, this.branchLengths, bot2, this.branchLengths);
                    if (sample.getFirst() == null) continue;
                    samples.incrementCount(sample.getFirst(), Math.exp(sample.getSecond()));
                }
                samples.incrementAll(fromPrev);
                fromPrev = new Counter();
                fromPrev.incrementAll(samples);
                samples.normalize();
                BayesRiskMinimizer<String> brm = new BayesRiskMinimizer<String>(BayesRiskMinimizer.levenshteinLoss);
                String best = brm.findMin(samples);
                LogInfo.logs("truth\t" + start);
                LogInfo.logs("recon\t" + best);
                double loss = BayesRiskMinimizer.levenshteinLoss.loss(start, best);
                LogInfo.logs("lev\t" + loss);
                output.write("reconstructions", "nParticles", K, "dist", loss);
                output.flush();
                LogInfo.end_track();
            }
            output.close();
            LogInfo.end_track();
        }
    }
}

