/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MachineAccuracy;
import dr.math.MultivariateFunction;
import dr.math.UnivariateFunction;
import dr.math.UnivariateMinimum;

public class LineFunction
implements UnivariateFunction {
    private MultivariateFunction f;
    private int lowerBoundParam;
    private int upperBoundParam;
    private int dim;
    private double lowerBound;
    private double upperBound;
    private double[] s;
    private double[] d;
    private double[] x;
    private UnivariateMinimum um = null;

    public LineFunction(MultivariateFunction func) {
        this.f = func;
        this.dim = this.f.getNumArguments();
        this.x = new double[this.dim];
    }

    public void update(double[] start, double[] dir) {
        this.s = start;
        this.d = dir;
        this.computeBounds();
    }

    public void getPoint(double lambda, double[] p) {
        for (int i = 0; i < this.dim; ++i) {
            p[i] = this.s[i] + lambda * this.d[i];
        }
    }

    @Override
    public double evaluate(double lambda) {
        this.getPoint(lambda, this.x);
        return this.f.evaluate(this.x);
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    public double findMinimum() {
        if (this.um == null) {
            this.um = new UnivariateMinimum();
        }
        return this.um.findMinimum(this);
    }

    public int getUpperBoundParameter() {
        return this.upperBoundParam;
    }

    public int getLowerBoundParameter() {
        return this.lowerBoundParam;
    }

    public boolean checkPoint(double[] p) {
        boolean modified = false;
        for (int i = 0; i < this.dim; ++i) {
            if (p[i] < this.f.getLowerBound(i)) {
                p[i] = this.f.getLowerBound(i);
                modified = true;
            }
            if (!(p[i] > this.f.getUpperBound(i))) continue;
            p[i] = this.f.getUpperBound(i);
            modified = true;
        }
        return modified;
    }

    public int checkVariables(double[] p, double[] grad, boolean[] active) {
        double EPS = MachineAccuracy.SQRT_EPSILON;
        int numActive = 0;
        for (int i = 0; i < this.dim; ++i) {
            active[i] = true;
            if (p[i] <= this.f.getLowerBound(i) + EPS) {
                if (!(grad[i] > 0.0)) continue;
                active[i] = false;
                continue;
            }
            if (p[i] >= this.f.getUpperBound(i) - EPS) {
                if (!(grad[i] < 0.0)) continue;
                active[i] = false;
                continue;
            }
            ++numActive;
        }
        return numActive;
    }

    public int checkDirection(double[] p, double[] dir) {
        double EPS = MachineAccuracy.SQRT_EPSILON;
        int numChanged = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (p[i] <= this.f.getLowerBound(i) + EPS) {
                if (!(dir[i] < 0.0)) continue;
                dir[i] = 0.0;
                ++numChanged;
                continue;
            }
            if (!(p[i] >= this.f.getUpperBound(i) - EPS) || !(dir[i] > 0.0)) continue;
            dir[i] = 0.0;
            ++numChanged;
        }
        return numChanged;
    }

    private void computeBounds() {
        boolean firstVisit = true;
        for (int i = 0; i < this.dim; ++i) {
            if (this.d[i] == 0.0) continue;
            double upper = (this.f.getUpperBound(i) - this.s[i]) / this.d[i];
            double lower = (this.f.getLowerBound(i) - this.s[i]) / this.d[i];
            if (lower > upper) {
                double tmp = upper;
                upper = lower;
                lower = tmp;
            }
            if (firstVisit) {
                this.lowerBound = lower;
                this.lowerBoundParam = i;
                this.upperBound = upper;
                this.upperBoundParam = i;
                firstVisit = false;
                continue;
            }
            if (lower > this.lowerBound) {
                this.lowerBound = lower;
                this.lowerBoundParam = i;
            }
            if (!(upper < this.upperBound)) continue;
            this.upperBound = upper;
            this.upperBoundParam = i;
        }
    }
}

