/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ComplexArray;
import dr.math.FastFourierTransform;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;
import dr.util.HeapSort;

public class LogTransformedNormalKDEDistribution
extends KernelDensityEstimatorDistribution {
    public static final int MINIMUM_GRID_SIZE = 2048;
    private ComplexArray kOrdinates;
    private double[] xPoints;
    private double[] finalXPoints;
    private double[] backupXPoints;
    private double[] densityPoints;
    private double[] finalDensityPoints;
    private double[] backupSample;
    private double[] logSample;
    private int gridSize;
    private double cut;
    private double from;
    private double to;
    private double lo;
    private double up;
    private boolean densityKnown = false;

    public LogTransformedNormalKDEDistribution(Double[] sample) {
        this(sample, null, null, null);
    }

    public LogTransformedNormalKDEDistribution(Double[] sample, int n) {
        this(sample, null, null, null, 3.0, n);
    }

    public LogTransformedNormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth) {
        this(sample, lowerBound, upperBound, bandWidth, 3.0, 2048);
    }

    public LogTransformedNormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth, int n) {
        this(sample, lowerBound, upperBound, bandWidth, 3.0, n);
    }

    public LogTransformedNormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth, double cut, int n) {
        super(sample, lowerBound, upperBound, bandWidth);
        int i;
        System.out.println("Creating the KDE in log space");
        System.out.println("lowerBound = " + lowerBound);
        System.out.println("upperBound = " + upperBound);
        this.logSample = new double[sample.length];
        for (i = 0; i < this.logSample.length; ++i) {
            this.logSample[i] = Math.log(sample[i]);
        }
        this.backupSample = new double[sample.length];
        for (i = 0; i < sample.length; ++i) {
            this.backupSample[i] = sample[i];
        }
        this.sample = this.logSample;
        this.processBounds(lowerBound, upperBound);
        this.setBandWidth(bandWidth);
        this.gridSize = Math.max(n, 2048);
        if (this.gridSize > 2048) {
            this.gridSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.gridSize) / Math.log(2.0)));
        }
        this.cut = cut;
        this.from = DiscreteStatistics.min(this.sample) - this.cut * this.bandWidth;
        this.to = DiscreteStatistics.max(this.sample) + this.cut * this.bandWidth;
        System.out.println("bandWidth = " + this.bandWidth);
        System.out.println("cut = " + this.cut);
        System.out.println("from = " + this.from);
        System.out.println("to = " + this.to);
        this.lo = this.from - 4.0 * this.bandWidth;
        this.up = this.to + 4.0 * this.bandWidth;
        System.out.println("lo = " + this.lo);
        System.out.println("up = " + this.up);
        this.densityKnown = false;
        this.computeDensity();
    }

    public double getFromPoint() {
        return this.from;
    }

    public double getToPoint() {
        return this.to;
    }

    private double linearApproximate(double[] x, double[] y, double pt, double low, double high) {
        int i = 0;
        int j = x.length - 1;
        if (pt < x[i]) {
            return low;
        }
        if (pt > x[j]) {
            return high;
        }
        while (i < j - 1) {
            int ij = (i + j) / 2;
            if (pt < x[ij]) {
                j = ij;
                continue;
            }
            i = ij;
        }
        if (pt == x[j]) {
            return y[j];
        }
        if (pt == x[i]) {
            return y[i];
        }
        return y[i] + (y[j] - y[i]) * ((pt - x[i]) / (x[j] - x[i]));
    }

    private double[] rescaleAndTrim(double[] x) {
        int length = x.length / 2;
        double scale = 1.0 / (double)x.length;
        double[] out = new double[length];
        for (int i = 0; i < length; ++i) {
            out[i] = x[i] * scale;
            if (!(out[i] < 0.0)) continue;
            out[i] = 0.0;
        }
        return out;
    }

    private double[] massdist(double[] x, double xlow, double xhigh, int ny) {
        int nx = x.length;
        double[] y = new double[ny * 2];
        boolean ixmin = false;
        int ixmax = ny - 2;
        double xdelta = (xhigh - xlow) / (double)(ny - 1);
        for (int i = 0; i < ny; ++i) {
            y[i] = 0.0;
        }
        double xmi = 1.0 / (double)nx;
        for (int i = 0; i < nx; ++i) {
            double xpos = (x[i] - xlow) / xdelta;
            int ix = (int)Math.floor(xpos);
            double fx = xpos - (double)ix;
            if (0 <= ix && ix <= ixmax) {
                int n = ix;
                y[n] = y[n] + (1.0 - fx) * xmi;
                int n2 = ix + 1;
                y[n2] = y[n2] + fx * xmi;
                continue;
            }
            if (ix == -1) {
                y[0] = y[0] + fx * xmi;
                continue;
            }
            if (ix != ixmax + 1) continue;
            int n = ix;
            y[n] = y[n] + (1.0 - fx) * xmi;
        }
        return y;
    }

    protected void fillKernelOrdinates(ComplexArray ordinates, double bandWidth) {
        int length = ordinates.length;
        double a = 1.0 / (Math.sqrt(Math.PI * 2) * bandWidth);
        double precision = -0.5 / (bandWidth * bandWidth);
        for (int i = 0; i < length; ++i) {
            double x = ordinates.real[i];
            ordinates.real[i] = a * Math.exp(x * x * precision);
        }
    }

    protected void computeDensity() {
        this.makeOrdinates();
        this.transformData();
        this.transformEstimator();
        this.densityKnown = true;
    }

    private void transformEstimator() {
        int i;
        System.out.println("\nCreating the KDE in normal space");
        System.out.println("lowerBound = " + this.lowerBound);
        System.out.println("upperBound = " + this.upperBound);
        this.sample = this.backupSample;
        this.setBandWidth(null);
        this.from = DiscreteStatistics.min(this.sample) - this.cut * this.bandWidth;
        this.to = DiscreteStatistics.max(this.sample) + this.cut * this.bandWidth;
        System.out.println("bandWidth = " + this.bandWidth);
        System.out.println("cut = " + this.cut);
        System.out.println("from = " + this.from);
        System.out.println("to = " + this.to);
        this.lo = this.from - 4.0 * this.bandWidth;
        this.up = this.to + 4.0 * this.bandWidth;
        System.out.println("lo = " + this.lo);
        System.out.println("up = " + this.up);
        this.backupXPoints = new double[this.xPoints.length];
        System.arraycopy(this.xPoints, 0, this.backupXPoints, 0, this.xPoints.length);
        this.makeOrdinates();
        int numberOfNegatives = 0;
        System.out.println("\nxPoints length = " + this.xPoints.length);
        for (i = 0; i < this.xPoints.length; ++i) {
            if (!(this.xPoints[i] < 0.0)) continue;
            ++numberOfNegatives;
        }
        System.out.println("number of negative xPoints = " + numberOfNegatives);
        this.finalXPoints = new double[this.xPoints.length - numberOfNegatives];
        System.arraycopy(this.xPoints, numberOfNegatives, this.finalXPoints, 0, this.xPoints.length - numberOfNegatives);
        for (i = 0; i < this.xPoints.length; ++i) {
            System.out.println(this.backupXPoints[i] + " : " + this.densityPoints[i]);
        }
        System.out.println("\nfinalXPoints length = " + this.finalXPoints.length);
        this.finalDensityPoints = new double[this.densityPoints.length - numberOfNegatives];
        for (i = 0; i < this.finalXPoints.length; ++i) {
            this.finalDensityPoints[i] = this.linearApproximate(this.backupXPoints, this.densityPoints, Math.log(this.finalXPoints[i]), 0.0, 0.0) * (1.0 / this.finalXPoints[i]);
            System.out.println(this.finalXPoints[i] + " : " + this.finalDensityPoints[i]);
        }
    }

    private void transformData() {
        ComplexArray Y = new ComplexArray(this.massdist(this.logSample, this.lo, this.up, this.gridSize));
        FastFourierTransform.fft(Y, false);
        ComplexArray product = Y.product(this.kOrdinates);
        FastFourierTransform.fft(product, true);
        this.densityPoints = this.rescaleAndTrim(product.real);
    }

    private void makeOrdinates() {
        int i;
        int length = 2 * this.gridSize;
        if (this.kOrdinates == null) {
            this.kOrdinates = new ComplexArray(new double[length]);
        }
        double max = 2.0 * (this.up - this.lo);
        double value = 0.0;
        double inc = max / (double)(length - 1);
        for (i = 0; i <= this.gridSize; ++i) {
            this.kOrdinates.real[i] = value;
            value += inc;
        }
        for (i = this.gridSize + 1; i < length; ++i) {
            this.kOrdinates.real[i] = -this.kOrdinates.real[length - i];
        }
        this.fillKernelOrdinates(this.kOrdinates, this.bandWidth);
        FastFourierTransform.fft(this.kOrdinates, false);
        this.kOrdinates.conjugate();
        this.xPoints = new double[this.gridSize];
        double x = this.lo;
        double delta = (this.up - this.lo) / (double)(this.gridSize - 1);
        for (int i2 = 0; i2 < this.gridSize; ++i2) {
            this.xPoints[i2] = x;
            x += delta;
        }
    }

    @Override
    protected double evaluateKernel(double x) {
        if (!this.densityKnown) {
            this.computeDensity();
        }
        return this.linearApproximate(this.finalXPoints, this.finalDensityPoints, x, 0.0, 0.0);
    }

    @Override
    protected void processBounds(Double lowerBound, Double upperBound) {
        if (lowerBound != null && lowerBound != Double.NEGATIVE_INFINITY || upperBound != null && upperBound != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("LogTransformedNormalKDEDistribution must be unbounded");
        }
    }

    @Override
    protected void setBandWidth(Double bandWidth) {
        this.bandWidth = bandWidth == null ? this.bandwidthNRD(this.sample) : bandWidth.doubleValue();
        this.densityKnown = false;
    }

    public double bandwidthNRD(double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        double h = (DiscreteStatistics.quantile(0.75, x, indices) - DiscreteStatistics.quantile(0.25, x, indices)) / 1.34;
        return 1.06 * Math.min(Math.sqrt(DiscreteStatistics.variance(x)), h) * Math.pow(x.length, -0.2);
    }
}

