/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class TDistribution
implements Distribution {
    private double df;
    private double scale;
    private double center;
    private static double logSqrtPi = Math.log(Math.sqrt(Math.PI));

    TDistribution(double center, double scale, double df) {
        this.center = center;
        this.scale = scale;
        this.df = df;
    }

    @Override
    public double pdf(double x) {
        return Math.exp(TDistribution.logPDF(x, this.center, this.scale, this.df));
    }

    @Override
    public double logPdf(double x) {
        return TDistribution.logPDF(x, this.center, this.scale, this.df);
    }

    @Override
    public double cdf(double x) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double y) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        if (this.df > 1.0) {
            return this.center;
        }
        return Double.NaN;
    }

    @Override
    public double variance() {
        if (this.df > 2.0) {
            return this.scale * this.df / (this.df - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public static double logPDF(double x, double x0, double scale, double df) {
        double loc = x - x0;
        double logPDF = GammaFunction.lnGamma((df + 1.0) / 2.0) - 0.5 * Math.log(df) - logSqrtPi - 0.25 * Math.log(scale) - GammaFunction.lnGamma(df / 2.0) - (df + 1.0) / 2.0 * Math.log(1.0 + loc * loc / df / scale);
        return logPDF;
    }
}

