/*
 * Decompiled with CFR 0.152.
 */
package dr.math.iterations;

import dr.math.functionEval.DrMath;

public abstract class IterativeProcess {
    private int iterations;
    private int maximumIterations = 50;
    private double desiredPrecision = DrMath.defaultNumericalPrecision();
    private double precision;

    public void evaluate() {
        this.iterations = 0;
        this.initializeIterations();
        while (this.iterations++ < this.maximumIterations) {
            this.precision = this.evaluateIteration();
            if (!this.hasConverged()) continue;
        }
        this.finalizeIterations();
    }

    public abstract double evaluateIteration();

    public void finalizeIterations() {
    }

    public double getDesiredPrecision() {
        return this.desiredPrecision;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public double getPrecision() {
        return this.precision;
    }

    public boolean hasConverged() {
        return this.precision < this.desiredPrecision;
    }

    public void initializeIterations() {
    }

    public double relativePrecision(double epsilon, double x) {
        return x > DrMath.defaultNumericalPrecision() ? epsilon / x : epsilon;
    }

    public void setDesiredPrecision(double prec) throws IllegalArgumentException {
        if (prec <= 0.0) {
            throw new IllegalArgumentException("Non-positive precision: " + prec);
        }
        this.desiredPrecision = prec;
    }

    public void setMaximumIterations(int maxIter) throws IllegalArgumentException {
        if (maxIter < 1) {
            throw new IllegalArgumentException("Non-positive maximum iteration: " + maxIter);
        }
        this.maximumIterations = maxIter;
    }
}

