/*
 * Decompiled with CFR 0.152.
 */
package dr.matrix;

import dr.matrix.ColumnVector;
import dr.matrix.ConcreteMatrix;
import dr.matrix.MutableMatrix;
import dr.matrix.RowVector;
import org.apache.commons.math.linear.RealMatrixImpl;

public interface Matrix {
    public int getRowCount();

    public int getColumnCount();

    public int getElementCount();

    public int getTriangleCount() throws NotSquareException;

    public int getDiagonalCount() throws NotSquareException;

    public double[] getElements();

    public double[][] getElements2D();

    public double[] getUpperTriangle() throws NotSquareException;

    public double[] getLowerTriangle() throws NotSquareException;

    public double[] getDiagonal() throws NotSquareException;

    public double getElement(int var1, int var2);

    public double getElement(int var1);

    public double[] getRow(int var1);

    public double[] getColumn(int var1);

    public double getMinValue();

    public double getMaxValue();

    public boolean getIsSquare();

    public boolean getIsSymmetric() throws NotSquareException;

    public String getRowId(int var1);

    public String getColumnId(int var1);

    public static abstract class AbstractMatrix
    implements Matrix {
        @Override
        public int getElementCount() {
            return this.getRowCount() * this.getColumnCount();
        }

        @Override
        public int getTriangleCount() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int dim = this.getRowCount();
            return (dim - 1) * dim / 2;
        }

        @Override
        public int getDiagonalCount() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            return this.getRowCount();
        }

        @Override
        public double[] getElements() {
            double[] values = new double[this.getElementCount()];
            int k = 0;
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    values[k] = this.getElement(r, c);
                    ++k;
                }
            }
            return values;
        }

        @Override
        public double[][] getElements2D() {
            double[][] values = new double[this.getRowCount()][this.getColumnCount()];
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    values[r][c] = this.getElement(r, c);
                }
            }
            return values;
        }

        @Override
        public double getElement(int index) {
            int r = index / this.getColumnCount();
            int c = index % this.getColumnCount();
            return this.getElement(r, c);
        }

        @Override
        public double[] getUpperTriangle() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            double[] values = new double[this.getTriangleCount()];
            int k = 0;
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                for (int c = r + 1; c < dim; ++c) {
                    values[k] = this.getElement(r, c);
                    ++k;
                }
            }
            return values;
        }

        @Override
        public double[] getLowerTriangle() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            double[] values = new double[this.getTriangleCount()];
            int k = 0;
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                for (int c = 0; c < r; ++c) {
                    values[k] = this.getElement(r, c);
                    ++k;
                }
            }
            return values;
        }

        @Override
        public double[] getDiagonal() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int dim = this.getRowCount();
            double[] values = new double[dim];
            for (int r = 0; r < dim; ++r) {
                values[r] = this.getElement(r, r);
            }
            return values;
        }

        @Override
        public double[] getRow(int row) {
            int dim = this.getColumnCount();
            double[] values = new double[dim];
            for (int c = 0; c < dim; ++c) {
                values[c] = this.getElement(row, c);
            }
            return values;
        }

        @Override
        public double[] getColumn(int column) {
            int dim = this.getRowCount();
            double[] values = new double[dim];
            for (int r = 0; r < dim; ++r) {
                values[r] = this.getElement(r, column);
            }
            return values;
        }

        @Override
        public double getMinValue() {
            double minValue = this.getElement(0);
            int n = this.getElementCount();
            for (int i = 1; i < n; ++i) {
                double value = this.getElement(i);
                if (!(value < minValue)) continue;
                minValue = value;
            }
            return minValue;
        }

        @Override
        public double getMaxValue() {
            double maxValue = this.getElement(0);
            int n = this.getElementCount();
            for (int i = 1; i < n; ++i) {
                double value = this.getElement(i);
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
            return maxValue;
        }

        @Override
        public boolean getIsSquare() {
            return this.getRowCount() == this.getColumnCount();
        }

        @Override
        public boolean getIsSymmetric() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                int c = r + 1;
                while (r < dim) {
                    if (this.getElement(r, c) != this.getElement(c, r)) {
                        return false;
                    }
                    ++r;
                }
            }
            return true;
        }

        @Override
        public String getRowId(int row) {
            return null;
        }

        @Override
        public String getColumnId(int column) {
            return null;
        }
    }

    public static class Util {
        public static double dotProduct(Matrix a, Matrix b) {
            throw new RuntimeException("not implemented yet");
        }

        public static void product(Matrix a, Matrix b, MutableMatrix result) throws WrongDimensionException {
            int rca = a.getRowCount();
            int cca = a.getColumnCount();
            int rcb = b.getRowCount();
            int ccb = b.getColumnCount();
            if (cca != rcb) {
                throw new WrongDimensionException("column count of matrix a = " + cca + ", row count of matrix b = " + rcb);
            }
            result.setDimension(rca, ccb);
            for (int r = 0; r < rca; ++r) {
                for (int c = 0; c < ccb; ++c) {
                    double sum = 0.0;
                    for (int i = 0; i < cca; ++i) {
                        sum += a.getElement(r, i) * b.getElement(i, c);
                    }
                    result.setElement(r, c, sum);
                }
            }
        }

        public static void kroneckerProduct(Matrix a, Matrix b, MutableMatrix result) {
            int rca = a.getRowCount();
            int cca = a.getColumnCount();
            int rcb = b.getRowCount();
            int ccb = b.getColumnCount();
            for (int rb = 0; rb < rcb; ++rb) {
                for (int cb = 0; cb < ccb; ++cb) {
                    for (int ra = 0; ra < rca; ++ra) {
                        for (int ca = 0; ca < cca; ++ca) {
                            result.setElement(rb * rca + ra, cb * cca + ca, a.getElement(ra, ca) * b.getElement(rb, cb));
                        }
                    }
                }
            }
        }

        public static void add(Matrix a, Matrix b, MutableMatrix result) throws WrongDimensionException {
            int rca = a.getRowCount();
            int cca = a.getColumnCount();
            if (rca != b.getRowCount() || cca != b.getColumnCount()) {
                throw new WrongDimensionException();
            }
            result.setDimension(rca, cca);
            for (int r = 0; r < rca; ++r) {
                for (int c = 0; c < cca; ++c) {
                    result.setElement(r, c, a.getElement(r, c) + b.getElement(r, c));
                }
            }
        }

        public static void subtract(Matrix a, Matrix b, MutableMatrix result) throws WrongDimensionException {
            int rca = a.getRowCount();
            int cca = a.getColumnCount();
            if (rca != b.getRowCount() || cca != b.getColumnCount()) {
                throw new WrongDimensionException();
            }
            result.setDimension(rca, cca);
            for (int r = 0; r < rca; ++r) {
                for (int c = 0; c < cca; ++c) {
                    result.setElement(r, c, a.getElement(r, c) - b.getElement(r, c));
                }
            }
        }

        public static double det(Matrix matrix) throws NotSquareException {
            int col;
            int n = matrix.getRowCount();
            if (n != (col = matrix.getColumnCount())) {
                throw new NotSquareException();
            }
            double[][] D2 = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    D2[i][j] = matrix.getElement(i, j);
                }
            }
            RealMatrixImpl RM = new RealMatrixImpl(D2);
            return RM.getDeterminant();
        }

        public static double logDet(Matrix matrix) throws NotSquareException {
            throw new RuntimeException("not implemented yet");
        }

        public static void invert(MutableMatrix matrix) throws NotSquareException {
            double alpha;
            int j;
            int i;
            int col;
            int n = matrix.getRowCount();
            if (n != (col = matrix.getColumnCount())) {
                throw new NotSquareException();
            }
            double[][] D2 = new double[n + 1][n * 2 + 2];
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j2 = 0; j2 < n; ++j2) {
                    D2[i2 + 1][j2 + 1] = matrix.getElement(i2, j2);
                }
            }
            int n2 = 2 * n;
            for (i = 1; i <= n; ++i) {
                for (j = 1; j <= n; ++j) {
                    D2[i][j + n] = 0.0;
                }
                D2[i][i + n] = 1.0;
            }
            for (i = 1; i <= n && (alpha = D2[i][i]) != 0.0; ++i) {
                for (j = 1; j <= n2; ++j) {
                    D2[i][j] = D2[i][j] / alpha;
                }
                for (int k = 1; k <= n; ++k) {
                    if (k - i == 0) continue;
                    double beta = D2[k][i];
                    for (j = 1; j <= n2; ++j) {
                        D2[k][j] = D2[k][j] - beta * D2[i][j];
                    }
                }
            }
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    matrix.setElement(i, j, D2[i + 1][j + n + 1]);
                }
            }
        }

        public static void invert(Matrix a, Matrix b, MutableMatrix result) throws NotSquareException, WrongDimensionException {
            throw new RuntimeException("not implemented yet");
        }

        public static void raise(Matrix matrix, double d, MutableMatrix result) throws NotSquareException {
            throw new RuntimeException("not implemented yet");
        }

        public static Matrix createColumnVector(double[] v) {
            return new ColumnVector(v);
        }

        public static Matrix createRowVector(double[] v) {
            return new RowVector(v);
        }

        public static MutableMatrix createMutableMatrix(double[][] values) {
            return new ConcreteMatrix(values);
        }
    }

    public static class WrongDimensionException
    extends MatrixException {
        private static final long serialVersionUID = -1799942797975356399L;

        WrongDimensionException() {
        }

        WrongDimensionException(String message) {
            super(message);
        }
    }

    public static class NotSquareException
    extends MatrixException {
        private static final long serialVersionUID = 5121968928197320497L;
    }

    public static class MatrixException
    extends Exception {
        private static final long serialVersionUID = -5904166681730282246L;

        MatrixException() {
        }

        MatrixException(String message) {
            super(message);
        }
    }
}

