/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Citation;
import java.util.List;

public interface Citable {
    public List<Citation> getCitations();

    public static class Utils {
        public static final String DEFAULT_PREPEND = "\t\t";
        public static final String DEFAULT_POSTPEND = "\n";

        public static String getCitationString(Citable citable, String prepend, String postpend) {
            List<Citation> citations = citable.getCitations();
            if (citations == null || citations.size() == 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            for (Citation citation : citations) {
                builder.append(prepend);
                builder.append(citation.toString());
                builder.append(postpend);
            }
            return builder.toString();
        }

        public static String getCitationString(Citable citable) {
            return Utils.getCitationString(citable, DEFAULT_PREPEND, DEFAULT_POSTPEND);
        }
    }
}

