/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.DataOutputStream;
import java.io.IOException;

public class TIFFWriter {
    public static final short MAXROWS = 6000;
    public static final short MAXCOLUMNS = 3000;
    public static final short GOOD_WRITE = 0;
    public static final short BAD_WRITE = 1;
    public static final short BAD_READ = 2;
    public static final short MEMORY_ERROR = 3;
    public static final short WRONG_BITS = 4;
    public static final short RGB_RED = 0;
    public static final short RGB_GREEN = 1;
    public static final short RGB_BLUE = 2;
    public static final short RGB_SIZE = 3;
    public static final short TIFFbyte = 1;
    public static final short TIFFascii = 2;
    public static final short TIFFshort = 3;
    public static final short TIFFlong = 4;
    public static final short TIFFrational = 5;
    public static final short NewSubFile = 254;
    public static final short SubFileType = 255;
    public static final short ImageWidth = 256;
    public static final short ImageLength = 257;
    public static final short RowsPerStrip = 278;
    public static final short StripOffsets = 273;
    public static final short StripByteCounts = 279;
    public static final short SamplesPerPixel = 277;
    public static final short BitsPerSample = 258;
    public static final short Compression = 259;
    public static final short PlanarConfiguration = 284;
    public static final short Group3Options = 292;
    public static final short Group4Options = 293;
    public static final short FillOrder = 266;
    public static final short Threshholding = 263;
    public static final short CellWidth = 264;
    public static final short CellLength = 265;
    public static final short MinSampleValue = 280;
    public static final short MaxSampleValue = 281;
    public static final short PhotoMetricInterp = 262;
    public static final short GrayResponseUnit = 290;
    public static final short GrayResponseCurve = 291;
    public static final short ColorResponseUnit = 300;
    public static final short ColorResponseCurves = 301;
    public static final short XResolution = 282;
    public static final short YResolution = 283;
    public static final short ResolutionUnit = 296;
    public static final short Orientation = 274;
    public static final short DocumentName = 269;
    public static final short PageName = 285;
    public static final short XPosition = 286;
    public static final short YPosition = 287;
    public static final short PageNumber = 297;
    public static final short ImageDescription = 270;
    public static final short Make = 271;
    public static final short Model = 272;
    public static final short FreeOffsets = 288;
    public static final short FreeByteCounts = 289;
    public static final short ColorMap = 320;
    public static final short Artist = 315;
    public static final short DateTime = 306;
    public static final short HostComputer = 316;
    public static final short Software = 305;

    public static void writeDoubleArray(DataOutputStream dataOut, double[][] inputImageInt) {
        int rows = inputImageInt.length;
        int columns = inputImageInt[0].length;
        if (rows < 0 || rows > 6000 || columns < 0 || columns > 3000) {
            throw new RuntimeException("Invalid # rows and # columns");
        }
        int pos = 8 + rows * columns;
        try {
            int i = 73;
            short j = (short)(i * 256 + i);
            TIFFWriter.fputword(dataOut, j);
            TIFFWriter.fputword(dataOut, (short)42);
            TIFFWriter.fputlong(dataOut, pos);
            for (i = 0; i < rows; i = (int)((short)(i + 1))) {
                for (j = 0; j < columns; j = (short)(j + 1)) {
                    int datum = (int)inputImageInt[i][j];
                    dataOut.writeByte((byte)datum);
                }
            }
            TIFFWriter.fputword(dataOut, (short)8);
            TIFFWriter.writetiftag(dataOut, (short)255, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOut, (short)256, (short)3, 1, columns);
            TIFFWriter.writetiftag(dataOut, (short)257, (short)3, 1, rows);
            TIFFWriter.writetiftag(dataOut, (short)258, (short)3, 1, 8);
            TIFFWriter.writetiftag(dataOut, (short)259, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOut, (short)262, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOut, (short)273, (short)4, 1, 8);
            TIFFWriter.writetiftag(dataOut, (short)284, (short)3, 1, 1);
            TIFFWriter.fputlong(dataOut, 0);
        }
        catch (IOException read) {
            System.out.println("Error occured while writing output file.");
        }
    }

    static void writetiftag(DataOutputStream dataOut, short tag, short type, int length, int offset) {
        TIFFWriter.fputword(dataOut, tag);
        TIFFWriter.fputword(dataOut, type);
        TIFFWriter.fputlong(dataOut, length);
        TIFFWriter.fputlong(dataOut, offset);
    }

    static void fputword(DataOutputStream dataOut, short n) {
        try {
            dataOut.writeByte((byte)n);
            dataOut.writeByte((byte)(n >> 8));
        }
        catch (IOException read) {
            System.out.println("Error occured while writing output file.");
        }
    }

    static void fputlong(DataOutputStream dataOut, int n) {
        try {
            dataOut.writeByte((byte)n);
            dataOut.writeByte((byte)(n >> 8));
            dataOut.writeByte((byte)(n >> 16));
            dataOut.writeByte((byte)(n >> 24));
        }
        catch (IOException read) {
            System.out.println("Error occured while writing output file.");
        }
    }
}

