/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.processors;

import ev.poi.PoissonModel;
import ev.poi.PoissonSampleProcessor;
import ev.poi.SampleContext;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Set;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.cons.CladeConsensus;

public class UnrootedCladesProcessor
implements PoissonSampleProcessor,
RootedTree.RootedTreeProcessor {
    private final Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> _unrootedClades = new Counter();
    private double nSamples = 0.0;

    @Override
    public void process(PoissonModel sample, SampleContext context) {
        this.process(sample.currentUnrooted());
    }

    public Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> getUnrootedCladesPosterior() {
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> result = new Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>>();
        for (UnorderedPair<Set<Taxon>, Set<Taxon>> key : this._unrootedClades.keySet()) {
            result.setCount(key, this._unrootedClades.getCount(key) / this.nSamples);
        }
        return result;
    }

    public UnrootedTree getConsensus(double threshold) {
        return CladeConsensus.consensusUnrootedTree(this.getUnrootedCladesPosterior(), threshold);
    }

    @Override
    public void process(RootedTree rt) {
        this.process(UnrootedTree.fromRooted(rt));
    }

    public void process(UnrootedTree ut) {
        for (UnorderedPair<Set<Taxon>, Set<Taxon>> clade : ut.inducedBiPartitions2BranchMap().keySet()) {
            this._unrootedClades.incrementCount(clade, 1.0);
        }
        this.nSamples += 1.0;
    }
}

