/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.proposals;

import ev.hmm.SimpleAligner;
import ev.poi.LargeStepHomologySampler;
import ev.poi.PoissonModel;
import ev.poi.proposals.PoissonProposal;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.util.CollUtils;

public class MSAProposal
implements PoissonProposal {
    private final MSAPoset msa;
    public final CognateId id;
    private final Set<Taxon> group1;
    private final PoissonModel model;
    private Collection<GreedyDecoder.Edge> removed = null;

    public MSAProposal(PoissonModel model, CognateId id, Set<Taxon> group1) {
        this.model = model;
        this.id = id;
        this.msa = model.alignments.get(id);
        this.group1 = group1;
    }

    private boolean somethingWasDone() {
        return this.removed != null;
    }

    @Override
    public double doProposal(Random rand, boolean maximize) {
        if (this.removed != null) {
            throw new RuntimeException();
        }
        if (this.group1.size() == 0 || this.group1.equals(this.msa.sequences().keySet())) {
            return 0.0;
        }
        ArrayList<Map<Taxon, Integer>> topLinearizedTaxon2Pos = CollUtils.list();
        ArrayList<Map<Taxon, Integer>> botLinearizedTaxon2Pos = CollUtils.list();
        DerivationTree.Derivation oldDeriv = LargeStepHomologySampler.originalDerivation(this.msa, this.group1, topLinearizedTaxon2Pos, botLinearizedTaxon2Pos);
        SimpleAligner aligner = LargeStepHomologySampler.createAligner(this.model.getCalculator(), this.msa.sequences(), topLinearizedTaxon2Pos, botLinearizedTaxon2Pos);
        DerivationTree.Derivation newDeriv = maximize ? aligner.viterbi() : aligner.sample(rand);
        this.removed = LargeStepHomologySampler.removeConnections(this.msa, this.group1);
        LargeStepHomologySampler.addConnections(this.msa, newDeriv, topLinearizedTaxon2Pos, botLinearizedTaxon2Pos);
        this.model.recomputeAlignmentLogLikelihood(this.id);
        return aligner.pathLogProbability(oldDeriv) - aligner.pathLogProbability(newDeriv);
    }

    @Override
    public void undo() {
        if (this.somethingWasDone()) {
            LargeStepHomologySampler.removeConnections(this.msa, this.group1);
            for (GreedyDecoder.Edge e : this.removed) {
                if (this.msa.tryAdding(e)) continue;
                throw new RuntimeException();
            }
            this.model.recomputeAlignmentLogLikelihood(this.id);
        }
    }

    @Override
    public String description() {
        return "MSAProposal";
    }
}

