/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.poi.exp.MSAOutput;
import ev.poi.exp.PhylogeneticOutput;
import ev.to.Clust;
import java.io.File;
import ma.MSAParser;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.util.IncrementalExperiment;

public class ExternalMSASystem
extends IncrementalExperiment.AbstractSystem {
    @Override
    public void inference(IncrementalExperiment.InferenceContext context) {
        File input = context.getInput();
        MSAPoset parsed = MSAParser.parseMSA(input);
        MultiAlignment result = Clust.clustal(parsed.toMultiAlignmentObject());
        File output = context.getMainOutputFile(MSAOutput.MSA_OUTPUT);
        result.saveToMSF(output);
    }

    @Override
    public String name() {
        return Clust.useProbCons ? "ProbCons" : "Clustal";
    }

    public static void main(String[] args) {
        ExternalMSASystem system = new ExternalMSASystem();
        IncrementalExperiment experiments = new IncrementalExperiment(system);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        IO.run(args, experiments, "clust", Clust.class);
    }
}

