/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.LogInfo;
import fig.basic.TDoubleMap;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class StringDoubleMap
implements Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final int growFactor = 2;
    private static final int defaultExpectedSize = 0;
    private static final double loadFactor = 0.75;
    private MapType mapType = MapType.HASH_TABLE;
    private boolean locked = false;
    private int num = 0;
    private String[] keys;
    private double[] values;
    private int numCollisions;

    public StringDoubleMap() {
        this(0);
    }

    public StringDoubleMap(int expectedSize) {
        this.allocate(this.getCapacity(this.num, false));
        this.numCollisions = 0;
    }

    public boolean containsKey(String key) {
        return this.find(key, false) != -1;
    }

    public double get(String key, double defaultValue) {
        int i = this.find(key, false);
        return i == -1 ? defaultValue : this.values[i];
    }

    public double getWithErrorMsg(String key, double defaultValue) {
        int i = this.find(key, false);
        if (i == -1) {
            LogInfo.error("%s not in map, using %f", key, defaultValue);
        }
        return i == -1 ? defaultValue : this.values[i];
    }

    public double getSure(String key) {
        int i = this.find(key, false);
        if (i == -1) {
            throw new RuntimeException("Missing key: " + key);
        }
        return this.values[i];
    }

    public void put(String key, double value) {
        assert (!Double.isNaN(value));
        int i = this.find(key, true);
        this.keys[i] = key;
        this.values[i] = value;
    }

    public void incr(String key, double dValue) {
        int i = this.find(key, true);
        this.keys[i] = key;
        if (Double.isNaN(this.values[i])) {
            this.values[i] = dValue;
        } else {
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void scale(String key, double dValue) {
        int i = this.find(key, true);
        if (i == -1) {
            return;
        }
        int n = i;
        this.values[n] = this.values[n] * dValue;
    }

    public int size() {
        return this.num;
    }

    public int capacity() {
        return this.keys.length;
    }

    public void gut() {
        this.values = null;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            sum += this.values[i];
        }
        return sum;
    }

    public void putAll(double value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            this.values[i] = value;
        }
    }

    public void incrAll(double dValue) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void multAll(double dValue) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int n = i;
            this.values[n] = this.values[n] * dValue;
        }
    }

    public StringDoubleMap copy() {
        StringDoubleMap newMap = new StringDoubleMap();
        newMap.mapType = this.mapType;
        newMap.locked = this.locked;
        newMap.num = this.num;
        newMap.keys = this.locked ? this.keys : (String[])this.keys.clone();
        newMap.values = (double[])this.values.clone();
        return newMap;
    }

    public StringDoubleMap restrict(Set<String> set) {
        StringDoubleMap newMap = new StringDoubleMap();
        newMap.mapType = this.mapType;
        if (this.mapType == MapType.SORTED_LIST) {
            newMap.allocate(this.getCapacity(this.num, false));
            for (int i = 0; i < this.keys.length; ++i) {
                if (!set.contains(this.keys[i])) continue;
                newMap.keys[newMap.num] = this.keys[i];
                newMap.values[newMap.num] = this.values[i];
                ++newMap.num;
            }
        } else if (this.mapType == MapType.HASH_TABLE) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || !set.contains(this.keys[i])) continue;
                newMap.put(this.keys[i], this.values[i]);
            }
        }
        newMap.locked = this.locked;
        return newMap;
    }

    public EntryValueComparator entryValueComparator() {
        return new EntryValueComparator();
    }

    public void lock() {
        this.locked = true;
    }

    public void switchToSortedList() {
        this.switchMapType(MapType.SORTED_LIST);
    }

    public void switchToHashTable() {
        this.switchMapType(MapType.HASH_TABLE);
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    public EntrySet entrySet() {
        return new EntrySet();
    }

    public KeySet keySet() {
        return new KeySet();
    }

    public ValueCollection values() {
        return new ValueCollection();
    }

    private int getCapacity(int n, boolean compact) {
        int capacity;
        if (this.mapType == MapType.SORTED_LIST) {
            capacity = compact ? n : n * 2;
        } else if (this.mapType == MapType.HASH_TABLE) {
            capacity = n * 2;
        } else {
            throw new RuntimeException("Internal bug");
        }
        return Math.max(capacity, 1);
    }

    private void switchMapType(MapType newMapType) {
        block5: {
            double[] oldValues;
            String[] oldKeys;
            block4: {
                int i;
                assert (!this.locked);
                oldKeys = this.keys;
                oldValues = this.values;
                this.mapType = newMapType;
                this.allocate(this.getCapacity(this.num, true));
                this.numCollisions = 0;
                if (newMapType != MapType.SORTED_LIST) break block4;
                Object[] entries = new FullEntry[this.num];
                int j = 0;
                for (i = 0; i < oldKeys.length; ++i) {
                    if (oldKeys[i] == null) continue;
                    entries[j++] = new FullEntry(oldKeys[i], oldValues[i]);
                }
                Arrays.sort(entries);
                for (i = 0; i < this.num; ++i) {
                    this.keys[i] = ((FullEntry)entries[i]).key;
                    this.values[i] = ((FullEntry)entries[i]).value;
                }
                break block5;
            }
            if (this.mapType != MapType.HASH_TABLE) break block5;
            this.num = 0;
            for (int i = 0; i < oldKeys.length; ++i) {
                if (oldKeys[i] == null) continue;
                this.put(oldKeys[i], oldValues[i]);
            }
        }
    }

    private int binarySearch(String targetKey) {
        int targetHash = StringDoubleMap.hash(targetKey);
        int l = 0;
        int u = this.num;
        while (l < u) {
            int m = l + u >> 1;
            int keyHash = StringDoubleMap.hash(this.keys[m]);
            if (targetHash < keyHash || targetHash == keyHash && targetKey.compareTo(this.keys[m]) <= 0) {
                u = m;
                continue;
            }
            l = m + 1;
        }
        return l;
    }

    private static int hash(String x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        if ((h ^= h >>> 10) < 0) {
            h = -h;
        }
        return h;
    }

    private int find(String key, boolean modify) {
        if (this.mapType == MapType.SORTED_LIST) {
            int i = this.binarySearch(key);
            if (i < this.num && this.keys[i] != null && key.equals(this.keys[i])) {
                return i;
            }
            if (modify) {
                if (this.locked) {
                    throw new RuntimeException("Cannot make new entry for " + key + ", because map is locked");
                }
                if (this.num == this.capacity()) {
                    this.changeSortedListCapacity(this.getCapacity(this.num + 1, false));
                }
                for (int j = this.num; j > i; --j) {
                    this.keys[j] = this.keys[j - 1];
                    this.values[j] = this.values[j - 1];
                }
                ++this.num;
                this.values[i] = Double.NaN;
                return i;
            }
            return -1;
        }
        if (this.mapType == MapType.HASH_TABLE) {
            int capacity = this.capacity();
            int keyHash = StringDoubleMap.hash(key);
            int i = keyHash % capacity;
            if (i < 0) {
                i = -i;
            }
            if (modify && (double)this.num > 0.75 * (double)capacity) {
                if (this.locked) {
                    throw new RuntimeException("Cannot make new entry for " + key + ", because map is locked");
                }
                this.switchMapType(MapType.HASH_TABLE);
                return this.find(key, modify);
            }
            while (this.keys[i] != null && !this.keys[i].equals(key)) {
                ++this.numCollisions;
                if (++i != capacity) continue;
                i = 0;
            }
            if (this.keys[i] != null) {
                assert (key.equals(this.keys[i]));
                return i;
            }
            if (modify) {
                ++this.num;
                this.values[i] = Double.NaN;
                return i;
            }
            return -1;
        }
        throw new RuntimeException("Internal bug: " + (Object)((Object)this.mapType));
    }

    private void allocate(int n) {
        this.keys = new String[n];
        this.values = new double[n];
    }

    private void changeSortedListCapacity(int newCapacity) {
        assert (this.mapType == MapType.SORTED_LIST);
        assert (newCapacity >= this.num);
        String[] oldKeys = this.keys;
        double[] oldValues = this.values;
        this.allocate(newCapacity);
        System.arraycopy(oldKeys, 0, this.keys, 0, this.num);
        System.arraycopy(oldValues, 0, this.values, 0, this.num);
    }

    private void repCheck() {
        assert (this.capacity() > 0);
        if (this.mapType == MapType.SORTED_LIST) {
            assert (this.num <= this.capacity());
            for (int i = 1; i < this.num; ++i) {
                int h1 = StringDoubleMap.hash(this.keys[i - 1]);
                int h2 = StringDoubleMap.hash(this.keys[i]);
                assert (h1 <= h2);
                if (h1 == h2) assert (this.keys[i - 1].compareTo(this.keys[i]) < 0);
            }
        }
    }

    private void debugDump() {
        System.out.println("--------------------");
        System.out.println("mapType = " + (Object)((Object)this.mapType));
        System.out.println("locked = " + this.locked);
        System.out.println("size/capacity = " + this.size() + "/" + this.capacity());
        System.out.println("numCollisions = " + this.numCollisions);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject((Object)this.mapType);
        out.writeInt(this.num);
        for (Entry e : this) {
            out.writeObject(e.getKey());
            out.writeDouble(e.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.mapType = (MapType)((Object)in.readObject());
        this.num = 0;
        this.locked = false;
        int n = in.readInt();
        this.allocate(this.getCapacity(n, true));
        for (int i = 0; i < n; ++i) {
            String key = ((String)in.readObject()).intern();
            double value = in.readDouble();
            if (this.mapType == MapType.SORTED_LIST) {
                this.keys[this.num] = key;
                this.values[this.num] = value;
                ++this.num;
                continue;
            }
            if (this.mapType != MapType.HASH_TABLE) continue;
            this.put(key, value);
        }
    }

    static void check(Set<Integer> set, StringDoubleMap map) {
        EntryIterator entryIterator = set.iterator();
        while (entryIterator.hasNext()) {
            int x = entryIterator.next();
            double value = map.getSure("" + x);
            assert (value == 1.0 * (double)x);
        }
        for (Entry e : map) {
            int x = Integer.parseInt(e.getKey());
            assert (set.contains(x));
            assert (e.getValue() == 1.0 * (double)x);
        }
    }

    static StringDoubleMap test(int n, int range) {
        int x;
        Random rand = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < n; ++i) {
            set.add(rand.nextInt(range));
        }
        StringDoubleMap map = new StringDoubleMap(0);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            x = (Integer)iterator.next();
            map.put("" + x, 1.0 * (double)x);
        }
        StringDoubleMap.check(set, map);
        map.switchToSortedList();
        StringDoubleMap.check(set, map);
        map.switchToHashTable();
        StringDoubleMap.check(set, map);
        map.lock();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            x = (Integer)iterator.next();
            map.put("" + x, 1.0 * (double)x);
        }
        assert (set.size() == map.size());
        return map;
    }

    public static void main(String[] args) throws Exception {
        int T = 200;
        int n = 10000;
        if (args[0].equals("ser")) {
            StringDoubleMap map = StringDoubleMap.test(10000, 10000);
            map.locked = false;
            map.switchToSortedList();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("map"));
            out.writeObject(map);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new FileInputStream("map"));
            StringDoubleMap map2 = (StringDoubleMap)in.readObject();
            in.close();
            assert (map.size() == map2.size());
            for (Entry e : map) {
                assert (map2.getSure(e.getKey()) == e.getValue());
            }
        } else {
            if (args[0].equals("test")) {
                int i = 0;
                while (true) {
                    System.out.println("test " + i);
                    StringDoubleMap.test(10000, 10000);
                    ++i;
                }
            }
            if (args[0].equals("sdm")) {
                StringDoubleMap map = new StringDoubleMap();
                for (int q = 0; q < T; ++q) {
                    for (int i = 0; i < n; ++i) {
                        map.put(i + "key" + i, i + q);
                    }
                    if (q != 0) continue;
                    map.switchToSortedList();
                    map.debugDump();
                }
            } else {
                HashMap<String, Double> omap = new HashMap<String, Double>();
                for (int q = 0; q < T; ++q) {
                    for (int i = 0; i < n; ++i) {
                        omap.put(i + "key" + i, 1.0 + (double)i + (double)q);
                    }
                }
            }
        }
    }

    public TDoubleMap toTDoubleMap() {
        TDoubleMap<String> map = new TDoubleMap<String>();
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            map.put(this.keys[i], this.values[i]);
        }
        return map;
    }

    private static enum MapType {
        SORTED_LIST,
        HASH_TABLE;

    }

    private abstract class MapIterator<E>
    implements Iterator<E> {
        private int next;
        private int end;

        public MapIterator() {
            this.end = StringDoubleMap.this.mapType == MapType.SORTED_LIST ? StringDoubleMap.this.size() : StringDoubleMap.this.capacity();
            this.next = -1;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.next < this.end;
        }

        int nextIndex() {
            int curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && StringDoubleMap.this.keys[this.next] == null);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueIterator
    extends MapIterator<Double> {
        private ValueIterator() {
        }

        @Override
        public Double next() {
            return StringDoubleMap.this.values[this.nextIndex()];
        }
    }

    private class KeyIterator
    extends MapIterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return StringDoubleMap.this.keys[this.nextIndex()];
        }
    }

    private class EntryIterator
    extends MapIterator<Entry> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            return new Entry(this.nextIndex());
        }
    }

    public class ValueCollection
    extends AbstractCollection<Double> {
        @Override
        public Iterator<Double> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return StringDoubleMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class KeySet
    extends AbstractSet<String> {
        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return StringDoubleMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            return StringDoubleMap.this.containsKey((String)o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class EntrySet
    extends AbstractSet<Entry> {
        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return StringDoubleMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class Entry {
        private final int i;

        private Entry(int i) {
            this.i = i;
        }

        public String getKey() {
            return StringDoubleMap.this.keys[this.i];
        }

        public double getValue() {
            return StringDoubleMap.this.values[this.i];
        }

        public void setValue(double newValue) {
            ((StringDoubleMap)StringDoubleMap.this).values[this.i] = newValue;
        }
    }

    public class EntryValueComparator
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            return Double.compare(StringDoubleMap.this.values[e1.i], StringDoubleMap.this.values[e2.i]);
        }
    }

    private static class FullEntry
    implements Comparable<FullEntry> {
        private final String key;
        private final double value;

        private FullEntry(String key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(FullEntry e) {
            int h2;
            int h1 = StringDoubleMap.hash(this.key);
            if (h1 != (h2 = StringDoubleMap.hash(e.key))) {
                return h1 - h2;
            }
            return this.key.compareTo(e.key);
        }
    }
}

