/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedStringMap;
import fig.basic.StrUtils;
import fig.exec.servlet.MyException;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.WebState;
import java.io.IOException;
import java.util.List;

public class ResponseParams
extends OrderedStringMap
implements ResponseObject {
    public ResponseParams() {
    }

    public ResponseParams(String msg) {
        this(true, msg);
    }

    public ResponseParams(boolean success, String msg) {
        this.setSuccess(success);
        if (msg != null) {
            this.setMsg(msg);
        }
    }

    public ResponseParams(boolean success, String goodMsg, String badMsg) {
        this(success, success ? goodMsg : badMsg);
    }

    public ResponseParams(MyException exception) {
        this(false, exception.getMessage());
        this.put("exception", (Object)true);
        int i = 0;
        for (StackTraceElement el : exception.getStackTrace()) {
            this.put("stackTrace" + i++, el);
        }
    }

    @Override
    public void put(String key, List<String> strings) {
        this.put(key, StrUtils.join(strings, "\t"));
    }

    public ResponseParams setSuccess(boolean success) {
        this.put("success", (Object)success);
        return this;
    }

    public ResponseParams setMsg(String msg) {
        this.put("msg", msg);
        return this;
    }

    public String getMsg() {
        return (String)this.get("msg");
    }

    @Override
    public void dump(WebState state) throws IOException {
        state.setPlainOutput();
        this.print(state.getWriter());
    }
}

