/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.DerivationTree;
import goblin.ObservationsTracker;
import goblin.ParamsTracker;
import goblin.Taxon;
import nuts.util.Arbre;

public class ExactDataLikelihood {
    private final ParamsTracker tracker;
    private final ObservationsTracker obs;

    public ExactDataLikelihood(ParamsTracker tracker, ObservationsTracker obs) {
        this.tracker = tracker;
        this.obs = obs;
    }

    public double logLikelihood(Arbre<DerivationTree.DerivationNode> root) {
        return Double.NaN;
    }

    public boolean isTractable(Arbre<DerivationTree.DerivationNode> root) {
        if (root.nodes().size() != 3 || root.getChildren().size() != 2) {
            return false;
        }
        Taxon topL = root.getContents().getLanguage();
        Taxon leftL = root.getChildren().get(0).getContents().getLanguage();
        Taxon rightL = root.getChildren().get(1).getContents().getLanguage();
        if (this.obs.isObserved(leftL) && this.obs.isObserved(rightL) && !this.obs.isObserved(topL)) {
            return true;
        }
        return this.obs.isObserved(leftL) && this.obs.isObserved(rightL) && this.obs.isObserved(topL);
    }

    public class IntractableLikelihoodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IntractableLikelihoodException(Arbre<DerivationTree.DerivationNode> root) {
            super("Loglikelihood is intractable,observation: " + ExactDataLikelihood.this.obs.toString() + ", tree:\n" + root.deepToString());
        }
    }
}

