/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import fig.exec.Execution;
import goblin.DataPrepUtils;
import goblin.ParamsTracker;
import goblin.ParamsTrackers;
import goblin.PrepareEMData;
import goblin.Taxon;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nuts.lang.StringUtils;
import pepper.Corpus;
import pepper.Edit;
import pepper.Encodings;
import pepper.ICSILanguageModel;
import pepper.editmodel.EditParam;
import pepper.editmodel.MainOptions;
import pepper.editmodel.OldMain;
import pepper.editmodel.ParamUpdater;
import pepper.editmodel.PhonemeModel;
import pepper.editmodel.TreeSampler;
import pepper.editmodel.Utils;

public class PrepareInitParam
implements Runnable {
    @Option(gloss="Type of rules to create")
    public MainOptions.RuleType ruleType = MainOptions.RuleType.IN_DEL_SUB;
    @Option(gloss="Initialization for rules x->x")
    public double initSelfSub = 90.0;
    @Option(gloss="Initialization for rules x->y")
    public double initSub = 8.0;
    @Option(gloss="Initialization for rule x->")
    public double initDel = 1.0;
    @Option(gloss="Initialization for rules x->y x or x->y x")
    public double initFis = 1.0;
    @Option(gloss="location of the init parameteters directory with [lang].params (if null, uses init* everywhere)")
    public String initParamSpecPath = "";
    @Option
    public ArrayList<String> langs = null;
    @Option(gloss="Generating param for rules x->x")
    public double genSelfSub = 90.0;
    @Option(gloss="Generating param for rules x->y")
    public double genSub = 8.0;
    @Option(gloss="Generating param for rules x->")
    public double genDel = 1.0;
    @Option(gloss="Generating param for rules x->y x or x->y x")
    public double genFis = 1.0;
    @Option(gloss="location of the generating parameteters directory with [lang].params (if null, uses init* everywhere)")
    public String genParamSpecPath = null;
    @Option
    public double mixSpecPathParamsWithUniform = 1.0E-4;
    @Option(gloss="Path to a 'Doug' formatted ICSI LM. If null uses uniform")
    public String icsiLMPath = null;
    public static final String initParamTrackerOutput = "initParamTracker.seri";
    public static final String genParamTrackerOutput = "genParamTracker.seri";
    public static final String paramUpdaterOutput = "paramUpdater.seri";
    private Encodings enc;
    private List<Edit> rules;
    private final ParamUpdater.ParamUpdaterOptions puOptions;
    private ParamUpdater paramUpdater;
    private ParamsTracker initParamsTracker;
    private ParamsTracker genParamsTracker;
    private PrepareEMData pemd;

    private String corpusPath() {
        return this.pemd.wordsPath;
    }

    private String topo() {
        return DataPrepUtils.optionallyLoad(this.pemd.topo);
    }

    private boolean isCorpusPathDefined() {
        return this.pemd == null ? false : this.pemd.isCorpusPathDefined();
    }

    public PrepareInitParam(ParamUpdater.ParamUpdaterOptions puOpt) {
        this.puOptions = puOpt;
    }

    public PrepareInitParam(ParamUpdater.ParamUpdaterOptions puOpt, PrepareEMData pemd) {
        this.puOptions = puOpt;
        this.pemd = pemd;
    }

    @Override
    public void run() {
        try {
            LogInfo.logs("Getting encoding..");
            this.enc = !this.isCorpusPathDefined() ? Encodings.getEncoding(Encodings.encodingsType) : OldMain.createEncodings(Corpus.parse(this.corpusPath()).allWords());
            this.prepareRules();
            this.initParamsTracker = this.createParam(this.initDel, this.initSelfSub, this.initSub, this.initFis, this.initParamSpecPath);
            this.genParamsTracker = this.createParam(this.genDel, this.genSelfSub, this.genSub, this.genFis, this.genParamSpecPath);
            this.createParamUpdater();
            this.saveData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveData() throws IOException {
        LogInfo.logs("Saving data..");
        ParamsTrackers.saveParamsTracker(this.initParamsTracker, PrepareInitParam.getInitParamTrackersOutPath());
        ParamsTrackers.saveParamsTracker(this.genParamsTracker, PrepareInitParam.getGenParamTrackersOutPath());
        Utils.saveParamUpdater(this.paramUpdater, PrepareInitParam.getParamUpdaterOutPath());
    }

    public static String getInitParamTrackersOutPath() {
        return Utils.safeGetExecFilePath(initParamTrackerOutput);
    }

    public static String getGenParamTrackersOutPath() {
        return Utils.safeGetExecFilePath(genParamTrackerOutput);
    }

    public static String getParamUpdaterOutPath() {
        return Utils.safeGetExecFilePath(paramUpdaterOutput);
    }

    private void createParamUpdater() {
        this.paramUpdater = new ParamUpdater.ParamUpdaterBuilder(this.puOptions, this.enc, this.rules).createParamUpdater();
    }

    private void prepareRules() {
        LogInfo.logs("Preparing rules..");
        if (this.ruleType != MainOptions.RuleType.IN_DEL_SUB) {
            throw new RuntimeException();
        }
        this.rules = OldMain.inDelSubRules(this.enc);
    }

    private ParamsTracker createParam(double del, double selfSub, double sub, double fis, String specPath) throws NumberFormatException, IOException {
        double nSub = this.enc.getNumberOfPhonemes() - 1;
        double nFis = this.enc.getNumberOfPhonemes() * 2 - 1;
        if (this.ruleType != MainOptions.RuleType.IN_DEL_SUB) {
            throw new RuntimeException();
        }
        LogInfo.logs("Creating init param..");
        HashSet<Edit> sparseStructure = new HashSet<Edit>();
        sparseStructure.addAll(this.rules);
        PhonemeModel phonemeModel = this.createPhonemeModel();
        if (sparseStructure.size() == 0) {
            throw new RuntimeException();
        }
        if (StrUtils.isEmpty(specPath)) {
            if (this.langs == null || this.langs.equals("")) {
                return new ParamsTrackers.HomoParamsTracker(TreeSampler.initEditParam(this.enc, sparseStructure, del, selfSub, sub / nSub, fis / nFis, false).removeTransitionsToBoundary(), phonemeModel);
            }
            HashMap<Taxon, EditParam> editParams = new HashMap<Taxon, EditParam>();
            for (String langName : this.langs) {
                Taxon lang = new Taxon(langName);
                EditParam cParam = TreeSampler.initEditParam(this.enc, sparseStructure, del, selfSub, sub / nSub, fis / nFis, false).removeTransitionsToBoundary();
                editParams.put(lang, cParam);
            }
            return new ParamsTrackers.ParamsTrackerMap(editParams, phonemeModel);
        }
        return this.parseParamsTracker(phonemeModel, specPath, this.mixSpecPathParamsWithUniform);
    }

    private ParamsTracker parseParamsTracker(PhonemeModel phonemeModel, String paramSpecPath, double uniMix) throws NumberFormatException, IOException {
        HashMap<Taxon, EditParam> editParams = new HashMap<Taxon, EditParam>();
        File paramsDir = new File(paramSpecPath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches(".*[.]params");
            }
        };
        EditParam uni = EditParam.uniform(this.enc);
        for (String fileName : paramsDir.list(filter)) {
            String langName = StringUtils.selectRegex("(.*)[.]params", fileName).get(0);
            Taxon lang = new Taxon(langName);
            String cFile = new File(paramsDir, fileName).getPath();
            EditParam cParam = EditParam.parseEditParam(this.enc, cFile);
            cParam = EditParam.mix(uni, cParam, uniMix);
            editParams.put(lang, cParam);
        }
        return new ParamsTrackers.ParamsTrackerMap(editParams, phonemeModel);
    }

    private PhonemeModel createPhonemeModel() {
        if (StrUtils.isEmpty(this.icsiLMPath)) {
            return new PhonemeModel(this.enc);
        }
        ICSILanguageModel icsiLM = new ICSILanguageModel(this.icsiLMPath);
        return new PhonemeModel(this.enc, icsiLM);
    }

    public static void main(String[] args) {
        ParamUpdater.ParamUpdaterOptions puOptions = new ParamUpdater.ParamUpdaterOptions();
        Execution.run(args, new PrepareInitParam(puOptions), "encodings", Encodings.class, "puOptions", puOptions);
    }
}

