/*
 * Decompiled with CFR 0.152.
 */
package ma;

import java.io.File;
import java.io.IOException;
import ma.BalibaseCorpus;
import ma.MultiAlignment;
import nuts.io.IO;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class AMAScore {
    public static void main(String[] args) throws IOException {
        SummaryStatistics stats = new SummaryStatistics();
        File directory = new File(args[0]);
        for (File file : IO.ls(directory, "msf")) {
            File alnFile = new File(file.getAbsolutePath().replaceAll("msf$", "aln"));
            try {
                File annFile = BalibaseCorpus.getBalibaseAnnFile(file, directory);
                if (!alnFile.exists()) {
                    System.err.println("Warning: does not have its aln file" + file);
                }
                MultiAlignment ma1 = MultiAlignment.parseMSFToMultiAlignment(file.getAbsolutePath(), annFile.getAbsolutePath());
                MultiAlignment ma2 = MultiAlignment.parseALNToMultiAlignment(alnFile.getAbsolutePath(), "");
                double curAMA = MultiAlignment.amaSim(ma1, ma2);
                stats.addValue(curAMA);
                System.out.println(file + ":" + curAMA);
            }
            catch (BalibaseCorpus.AnnNotFound anf) {
                System.err.println("Warning: ignored b/c no ann file found:" + file);
            }
        }
        System.out.println("Average:" + stats.getMean());
    }
}

