/*
 * Decompiled with CFR 0.152.
 */
package ma;

import goblin.DerivationTree;
import goblin.ObservationsTracker;
import java.util.Random;
import ma.MultiAlignment;
import nuts.math.RejectionSampler;
import nuts.util.Arbre;

public class LongGapParameterLearner {

    public static class GoldMultiAlignConstraint
    implements RejectionSampler.RejectionFilter<Arbre<DerivationTree.DerivationNode>> {
        private final MultiAlignment reference;
        private final ObservationsTracker obs;
        private Double currentF1 = null;
        private final int retries;
        private int currentTry = 0;

        public boolean useAnnealing() {
            return this.currentF1 != null;
        }

        public double getCurrentF1() {
            return this.currentF1;
        }

        public static GoldMultiAlignConstraint annealingGMAConstraint(MultiAlignment reference, ObservationsTracker obs, Arbre<DerivationTree.DerivationNode> initState, int retries) {
            return new GoldMultiAlignConstraint(reference, obs, initState, retries);
        }

        public GoldMultiAlignConstraint(MultiAlignment reference, ObservationsTracker obs) {
            this(reference, obs, null, 0);
        }

        private GoldMultiAlignConstraint(MultiAlignment reference, ObservationsTracker obs, Arbre<DerivationTree.DerivationNode> initState, int retries) {
            this.reference = reference;
            this.obs = obs;
            this.retries = retries;
            if (initState != null) {
                this.currentF1 = this.eval(initState);
            }
        }

        private double eval(Arbre<DerivationTree.DerivationNode> state) {
            return this.reference.sumOfPairsScore(MultiAlignment.inducedMultiAlignment(state, ObservationsTracker.modernObservationsTracker(state)));
        }

        @Override
        public boolean reject(Arbre<DerivationTree.DerivationNode> candidate) {
            MultiAlignment inducedAlign = MultiAlignment.inducedMultiAlignment(candidate, this.obs);
            if (this.useAnnealing()) {
                return this.annealReject(candidate);
            }
            return !inducedAlign.equals(this.reference);
        }

        private boolean annealReject(Arbre<DerivationTree.DerivationNode> candidate) {
            double newF1 = this.eval(candidate);
            if (newF1 < this.currentF1) {
                return true;
            }
            if (newF1 == this.currentF1 && this.currentTry < this.retries) {
                ++this.currentTry;
                return true;
            }
            this.currentTry = 0;
            this.currentF1 = newF1;
            return false;
        }
    }

    public static class FiltreEtrange
    implements RejectionSampler.RejectionFilter<Arbre<DerivationTree.DerivationNode>> {
        private MultiAlignment previous;
        private double etrangete = 0.9;
        private Random rand;

        public FiltreEtrange(Random rand, MultiAlignment initial) {
            this.rand = rand;
            this.previous = initial;
        }

        public FiltreEtrange(Random rand, Arbre<DerivationTree.DerivationNode> initial) {
            this.rand = rand;
            this.previous = MultiAlignment.inducedMultiAlignment(initial);
        }

        @Override
        public boolean reject(Arbre<DerivationTree.DerivationNode> candidate) {
            boolean result = false;
            MultiAlignment candidateMultiAlign = MultiAlignment.inducedMultiAlignment(candidate);
            if (this.previous != null) {
                if (candidateMultiAlign.gappiness() >= this.previous.gappiness()) {
                    if (this.rand.nextDouble() < this.etrangete) {
                        result = true;
                    } else {
                        System.out.println("Lucky escape");
                    }
                } else {
                    System.out.println("gapiness delta: " + this.previous.gappiness() + " -> " + candidateMultiAlign.gappiness());
                    this.previous = candidateMultiAlign;
                }
            }
            return result;
        }
    }
}

