/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.NumUtils;
import fig.basic.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nuts.io.IO;
import nuts.math.Fct;
import nuts.math.Id;
import pepper.Encodings;

public class SubstitutionMatrixLoader {
    @Option
    public static String dataPath = "data/matrices/";
    public static final String IGNORED_STAR = "*";
    public static final IntervalIndicator nonNegative = new IntervalIndicator(0.0, Double.POSITIVE_INFINITY);

    public static double[][] loadMatrix(String matrixName, Encodings enc) throws IOException {
        Id<Double> id = new Id<Double>();
        return SubstitutionMatrixLoader.loadMatrix(matrixName, enc, id);
    }

    public static String matrixToString(double[][] matrix, Encodings enc) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append(" ");
        for (i = 0; i < enc.getNumberOfPhonemes(); ++i) {
            result.append(enc.phoneId2Char(i) + " ");
        }
        result.append("\n");
        for (i = 0; i < enc.getNumberOfPhonemes(); ++i) {
            result.append(enc.phoneId2Char(i) + " ");
            for (int j = 0; j < enc.getNumberOfPhonemes(); ++j) {
                result.append(matrix[i][j] + " ");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static double[][] loadMatrix(String matrixName, Encodings enc, Fct<Double, Double> map) throws IOException {
        List<String> header = null;
        double[][] result = null;
        for (String line : IO.i(new File(dataPath, matrixName).getPath())) {
            if (line.matches("^[#].*") || line.matches("^\\s.$")) continue;
            if (header == null) {
                header = SubstitutionMatrixLoader.parseColumnNames(line, enc);
                int nPhones = enc.getNumberOfPhonemes();
                result = new double[nPhones][nPhones];
                continue;
            }
            SubstitutionMatrixLoader.parseRow(line, enc, header, result, map);
        }
        return result;
    }

    public static double l1(double[][] x, double[][] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                sum += Math.abs(x[i][j] - y[i][j]);
            }
        }
        return sum;
    }

    private static void parseRow(String line, Encodings enc, List<String> header, double[][] result, Fct<Double, Double> fct) {
        if (line.matches("^\\s*$")) {
            return;
        }
        String[] fields = line.split("\\s+");
        if (fields[0].equals(IGNORED_STAR)) {
            return;
        }
        char rowName = SubstitutionMatrixLoader.getSymbol(fields[0], enc);
        for (int i = 1; i < fields.length; ++i) {
            double value = Double.parseDouble(fields[i]);
            String columnNameStr = header.get(i);
            if (columnNameStr.equals(IGNORED_STAR)) continue;
            char columnName = SubstitutionMatrixLoader.getSymbol(header.get(i), enc);
            int rowId = enc.char2PhoneId(rowName);
            int columnId = enc.char2PhoneId(columnName);
            result[rowId][columnId] = fct.evalAt(value);
        }
    }

    private static char getSymbol(String string, Encodings enc) {
        if (string.length() != 1) {
            throw new RuntimeException("Bad string: " + string);
        }
        char currentChar = string.charAt(0);
        if (enc.char2PhoneId(currentChar) == -1) {
            throw new RuntimeException("" + currentChar + " not in the encoding");
        }
        return currentChar;
    }

    private static List<String> parseColumnNames(String line, Encodings enc) {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : line.split("\\s+")) {
            result.add(item);
        }
        return result;
    }

    public static double[][] exp(double[][] matrix, double scalar) {
        int size = matrix.length;
        double[][] result = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                result[i][j] = Math.exp(scalar * matrix[i][j]);
            }
        }
        NumUtils.normalize(result);
        return result;
    }

    public static void main(String[] args) throws IOException {
    }

    public static boolean isZero(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                if (matrix[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static class AlwaysOne
    implements Fct<Double, Double> {
        @Override
        public Double evalAt(Double x) {
            return 1.0;
        }
    }

    public static class Affine
    implements Fct<Double, Double> {
        private final double a;
        private final double b;

        public Affine(double a, double b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public Double evalAt(Double x) {
            return this.a * (x + this.b);
        }
    }

    public static class IntervalIndicator
    implements Fct<Double, Double> {
        private final double min;
        private final double max;

        public IntervalIndicator(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Double evalAt(Double x) {
            if (x >= this.min && x < this.max) {
                return 1.0;
            }
            return 0.0;
        }
    }
}

