/*
 * Decompiled with CFR 0.152.
 */
package nuts.lang;

import fig.basic.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayUtils {
    public static final double tolerance = 1.0E-4;

    public static void deepFill(Object o, double v) {
        if (o instanceof double[]) {
            double[] a = (double[])o;
            Arrays.fill(a, v);
        } else if (o instanceof Object[]) {
            Object[] a;
            for (Object cur : a = (Object[])o) {
                ArrayUtils.deepFill(cur, v);
            }
        } else {
            throw new RuntimeException();
        }
    }

    public static double[] fromCollection(List<Double> c) {
        double[] result = new double[c.size()];
        for (int i = 0; i < c.size(); ++i) {
            result[i] = c.get(i);
        }
        return result;
    }

    public static double[] delta(int size, int ... ns) {
        double[] result = new double[size];
        for (int n : ns) {
            result[n] = 1.0;
        }
        return result;
    }

    public static double max(double[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        for (double x : arr) {
            if (!(x > max)) continue;
            max = x;
        }
        return max;
    }

    public static double min(double[] arr) {
        double min = Double.POSITIVE_INFINITY;
        for (double x : arr) {
            if (!(x < min)) continue;
            min = x;
        }
        return min;
    }

    public static int argmax(double[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < arr.length; ++i) {
            double x = arr[i];
            if (!(x > max)) continue;
            argmax = i;
            max = x;
        }
        return argmax;
    }

    public static int[] integerCollection2Array(Collection<Integer> integers) {
        int[] result = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < integers.size(); ++i) {
            result[i] = iterator.next();
        }
        return result;
    }

    public static ArrayList<String> stringArray2List(String[] array) {
        if (array == null) {
            new RuntimeException("The provided array should not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : array) {
            result.add(item);
        }
        return result;
    }

    public static boolean sumsToOne(double[] numbers) {
        return Math.abs(ListUtils.sum(numbers) - 1.0) < 1.0E-4;
    }

    public static boolean jointlySumsToOne(double[][] numbers) {
        double sum = 0.0;
        double[][] dArray = numbers;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] slice;
            for (double number : slice = dArray[i]) {
                sum += number;
            }
        }
        return Math.abs(sum - 1.0) < 1.0E-4;
    }

    public static boolean condSumsToOne(double[][] condPrs) {
        for (int i = 0; i < condPrs.length; ++i) {
            if (ArrayUtils.sumsToOne(condPrs[i])) continue;
            return false;
        }
        return true;
    }

    public static double[][] parseMtx(String spec, String rowSep, String columnSep) {
        String[] rows = spec.split(rowSep);
        double[][] result = new double[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i];
            String[] columns = row.split(columnSep);
            result[i] = new double[columns.length];
            assert (i == 0 || result[i].length == result[i - 1].length);
            for (int j = 0; j < columns.length; ++j) {
                String entry = columns[j];
                result[i][j] = Double.parseDouble(entry);
            }
        }
        return result;
    }

    public static double[][] parseMtx(String spec) {
        return ArrayUtils.parseMtx(spec, ";", "\\s+");
    }

    public static String printMtx(double[][] mtx, String rowSep, String columnSep) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < mtx.length; ++i) {
            for (int j = 0; j < mtx[i].length; ++j) {
                builder.append(mtx[i][j] + columnSep);
            }
            builder.append(rowSep);
        }
        return builder.toString();
    }

    public static String printMtx(double[][] mtx) {
        return ArrayUtils.printMtx(mtx, "\n", " ");
    }

    public static void main(String[] args) {
        String spec = "1 2;3 4;5 6";
        System.out.println(ArrayUtils.printMtx(ArrayUtils.parseMtx(spec)));
    }

    public static double sum(double[] xs) {
        double sum = 0.0;
        for (double x : xs) {
            sum += x;
        }
        return sum;
    }
}

