/*
 * Decompiled with CFR 0.152.
 */
package nuts.ling;

import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;

public class TIPAConversion {
    public static String path = "/Users/bouchard/Documents/experiments/old-austro/data/ipaConversion";
    private static Map<Character, String> data = null;

    public static Map<Character, String> getData() {
        if (data == null) {
            data = CollUtils.map();
            for (String line : IO.i(path)) {
                String[] fields = line.split("\\t");
                if (fields[0].length() != 1) {
                    throw new RuntimeException();
                }
                char src = fields[0].charAt(0);
                if (data.containsKey(Character.valueOf(src))) {
                    throw new RuntimeException("Duplicate key:" + src);
                }
                if (fields.length == 1) {
                    data.put(Character.valueOf(src), "" + src);
                    continue;
                }
                if (fields.length == 2) {
                    data.put(Character.valueOf(src), fields[1]);
                    continue;
                }
                throw new RuntimeException();
            }
        }
        return data;
    }

    public static String surroundByTIPAString(String str, boolean isRecon) {
        return (isRecon ? "*" : "") + "\\textipa{" + str + "}";
    }

    public static String surroundConvert(String str, boolean isRecon) {
        return TIPAConversion.surroundByTIPAString(TIPAConversion.convert(str), isRecon);
    }

    public static String convert(String s) {
        StringBuilder result = new StringBuilder("");
        Map<Character, String> data = TIPAConversion.getData();
        for (char c : s.toCharArray()) {
            if (!data.containsKey(Character.valueOf(c))) {
                result.append("" + c);
                IO.se("Warning: character " + c + " not found in TIPA database");
                continue;
            }
            result.append(data.get(Character.valueOf(c)));
        }
        return result.toString();
    }
}

