/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.Option;
import fig.prob.Gamma;
import java.util.Random;
import nuts.math.Sampling;

public class PositiveParamResampler {
    public static <X> Step<X> resample(X current, PositiveParameterization<X> param, GammaParameters gamma, Random rand, double tuning) {
        double oldLogDens = param.unormLogDensity(current);
        double oldParam = param.param(current);
        double m = Sampling.nextDouble(rand, 1.0 / tuning, tuning);
        double newParam = m * oldParam;
        if (newParam < 0.0) {
            throw new RuntimeException();
        }
        X proposed = param.state(current, newParam);
        boolean inPlace = proposed == current;
        double newLogDens = param.unormLogDensity(proposed);
        double logRatio = Math.log(m) + newLogDens - oldLogDens;
        double acceptPr = Sampling.min1exp(logRatio);
        boolean accepted = Sampling.sampleBern(acceptPr, rand);
        X state = accepted ? proposed : (inPlace ? param.state(proposed, oldParam) : current);
        return new Step<X>(state, accepted, logRatio);
    }

    public static void main(String[] args) {
    }

    public static class Step<X> {
        public final X state;
        public final boolean accepted;
        public final double logRatio;

        public Step(X state, boolean accepted, double logRatio) {
            this.state = state;
            this.accepted = accepted;
            this.logRatio = logRatio;
        }
    }

    public static class GammaParameters {
        @Option
        public double shape = 1.01;
        @Option
        public double rate = 0.01;

        public Gamma getDistrib() {
            return new Gamma(this.shape, this.rate);
        }
    }

    public static interface PositiveParameterization<X> {
        public X state(X var1, double var2);

        public double param(X var1);

        public double unormLogDensity(X var1);
    }
}

