/*
 * Decompiled with CFR 0.152.
 */
package nuts.maxent;

import nuts.maxent.DifferentiableFunction;
import nuts.maxent.DoubleArrays;
import nuts.maxent.GradientLineSearcher;

public class BacktrackingLineSearcher
implements GradientLineSearcher {
    private double EPS = 1.0E-10;
    double stepSizeMultiplier = 0.9;
    private double sufficientDecreaseConstant = 1.0E-4;

    @Override
    public double[] minimize(DifferentiableFunction function, double[] initial, double[] direction) {
        double stepSize = 1.0;
        double initialFunctionValue = function.valueAt(initial);
        double initialDirectionalDerivative = DoubleArrays.innerProduct(function.derivativeAt(initial), direction);
        double[] guess = null;
        double guessValue = 0.0;
        boolean sufficientDecreaseObtained = false;
        while (!sufficientDecreaseObtained) {
            double sufficientDecreaseValue;
            guess = DoubleArrays.addMultiples(initial, 1.0, direction, stepSize);
            guessValue = function.valueAt(guess);
            sufficientDecreaseObtained = guessValue <= (sufficientDecreaseValue = initialFunctionValue + this.sufficientDecreaseConstant * initialDirectionalDerivative * stepSize);
            if (sufficientDecreaseObtained || !((stepSize *= this.stepSizeMultiplier) < this.EPS)) continue;
            System.err.println("BacktrackingSearcher.minimize: stepSize underflow.");
            return initial;
        }
        return guess;
    }

    public static void main(String[] args) {
        DifferentiableFunction function = new DifferentiableFunction(){

            @Override
            public int dimension() {
                return 1;
            }

            @Override
            public double valueAt(double[] x) {
                return x[0] * (x[0] - 0.01);
            }

            @Override
            public double[] derivativeAt(double[] x) {
                return new double[]{2.0 * x[0] - 0.01};
            }
        };
        BacktrackingLineSearcher lineSearcher = new BacktrackingLineSearcher();
        lineSearcher.minimize(function, new double[]{0.0}, new double[]{1.0});
    }
}

