/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuts.io.IteratorWrapper;
import nuts.util.Tree;

public class Trees {
    public static <S, T> Tree<T> transformTreeLabels(Tree<S> tree, LabelFactory<S, T> labelFactory) {
        T newLabel = labelFactory.newLabel(tree);
        ArrayList newChildren = new ArrayList();
        for (Tree<S> node : tree.getChildren()) {
            Tree<T> newNode = Trees.transformTreeLabels(node, labelFactory);
            newChildren.add(newNode);
        }
        return new Tree<T>(newLabel, newChildren);
    }

    public static Iterable<Tree<String>> readTrees(String fileName) throws IOException {
        BufferedReader in = IOUtils.openIn(fileName);
        PennTreeReader treeReader = new PennTreeReader(in);
        return IteratorWrapper.IW(treeReader);
    }

    public static void main(String[] args) {
        PennTreeReader reader = new PennTreeReader(new StringReader("((S (NP (DT the) (JJ quick) (JJ brown) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))"));
        Object tree = reader.next();
        System.out.println(PennTreeRenderer.render(tree));
        System.out.println(tree);
    }

    public static class PennTreeRenderer {
        public static <L> String render(Tree<L> tree) {
            StringBuilder sb = new StringBuilder();
            PennTreeRenderer.renderTree(tree, 0, false, false, false, true, sb);
            sb.append('\n');
            return sb.toString();
        }

        private static <L> void renderTree(Tree<L> tree, int indent, boolean parentLabelNull, boolean firstSibling, boolean leftSiblingPreTerminal, boolean topLevel, StringBuilder sb) {
            boolean suppressIndent;
            boolean bl = suppressIndent = parentLabelNull || firstSibling && tree.isPreTerminal() || leftSiblingPreTerminal && tree.isPreTerminal() && (tree.getLabel() == null || !tree.getLabel().toString().startsWith("CC"));
            if (suppressIndent) {
                sb.append(' ');
            } else {
                if (!topLevel) {
                    sb.append('\n');
                }
                for (int i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
            }
            if (tree.isLeaf() || tree.isPreTerminal()) {
                PennTreeRenderer.renderFlat(tree, sb);
                return;
            }
            sb.append('(');
            sb.append(tree.getLabel());
            PennTreeRenderer.renderChildren(tree.getChildren(), indent + 1, tree.getLabel() == null || tree.getLabel().toString() == null, sb);
            sb.append(')');
        }

        private static <L> void renderFlat(Tree<L> tree, StringBuilder sb) {
            if (tree.isLeaf()) {
                sb.append(tree.getLabel().toString());
                return;
            }
            sb.append('(');
            sb.append(tree.getLabel().toString());
            sb.append(' ');
            sb.append(tree.getChildren().get(0).getLabel().toString());
            sb.append(')');
        }

        private static <L> void renderChildren(List<Tree<L>> children, int indent, boolean parentLabelNull, StringBuilder sb) {
            boolean firstSibling = true;
            boolean leftSibIsPreTerm = true;
            for (Tree<L> child : children) {
                PennTreeRenderer.renderTree(child, indent, parentLabelNull, firstSibling, leftSibIsPreTerm, false, sb);
                leftSibIsPreTerm = child.isPreTerminal();
                if (child.getLabel() != null && child.getLabel().toString().startsWith("CC")) {
                    leftSibIsPreTerm = false;
                }
                firstSibling = false;
            }
        }
    }

    public static class PennTreeReader
    implements Iterator<Tree<String>> {
        public static String ROOT_LABEL = "ROOT";
        PushbackReader in;
        Tree<String> nextTree;

        @Override
        public boolean hasNext() {
            return this.nextTree != null;
        }

        @Override
        public Tree<String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tree<String> tree = this.nextTree;
            this.nextTree = this.readRootTree();
            return tree;
        }

        private Tree<String> readRootTree() {
            try {
                this.readWhiteSpace();
                if (!this.isLeftParen(this.peek())) {
                    return null;
                }
                return this.readTree(true);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading tree.");
            }
        }

        private Tree<String> readTree(boolean isRoot) throws IOException {
            this.readLeftParen();
            String label = this.readLabel();
            if (label.length() == 0 && isRoot) {
                label = ROOT_LABEL;
            }
            List children = this.readChildren();
            this.readRightParen();
            return new Tree<String>(label, children);
        }

        private String readLabel() throws IOException {
            this.readWhiteSpace();
            return this.readText();
        }

        private String readText() throws IOException {
            StringBuilder sb = new StringBuilder();
            int ch = this.in.read();
            while (!(this.isWhiteSpace(ch) || this.isLeftParen(ch) || this.isRightParen(ch))) {
                sb.append((char)ch);
                ch = this.in.read();
            }
            this.in.unread(ch);
            return sb.toString().intern();
        }

        private List<Tree<String>> readChildren() throws IOException {
            this.readWhiteSpace();
            if (!this.isLeftParen(this.peek())) {
                return Collections.singletonList(this.readLeaf());
            }
            return this.readChildList();
        }

        private int peek() throws IOException {
            int ch = this.in.read();
            this.in.unread(ch);
            return ch;
        }

        private Tree<String> readLeaf() throws IOException {
            String label = this.readText();
            return new Tree<String>(label);
        }

        private List<Tree<String>> readChildList() throws IOException {
            ArrayList<Tree<String>> children = new ArrayList<Tree<String>>();
            this.readWhiteSpace();
            while (!this.isRightParen(this.peek())) {
                children.add(this.readTree(false));
                this.readWhiteSpace();
            }
            return children;
        }

        private void readLeftParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isLeftParen(ch)) {
                throw new RuntimeException("Format error reading tree with character: (" + Character.valueOf((char)ch) + ")");
            }
        }

        private void readRightParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isRightParen(ch)) {
                throw new RuntimeException("Format error reading tree.");
            }
        }

        private void readWhiteSpace() throws IOException {
            int ch = this.in.read();
            while (this.isWhiteSpace(ch)) {
                ch = this.in.read();
            }
            this.in.unread(ch);
        }

        private boolean isWhiteSpace(int ch) {
            return ch == 32 || ch == 9 || ch == 12 || ch == 13 || ch == 10;
        }

        private boolean isLeftParen(int ch) {
            return ch == 40;
        }

        private boolean isRightParen(int ch) {
            return ch == 41;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public PennTreeReader(Reader in) {
            this.in = new PushbackReader(in);
            this.nextTree = this.readRootTree();
        }
    }

    public static interface LabelFactory<S, T> {
        public T newLabel(Tree<S> var1);
    }

    public static class StandardTreeNormalizer
    implements TreeTransformer<String> {
        EmptyNodeStripper emptyNodeStripper = new EmptyNodeStripper();
        XOverXRemover<String> xOverXRemover = new XOverXRemover();
        FunctionNodeStripper functionNodeStripper = new FunctionNodeStripper();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            tree = this.functionNodeStripper.transformTree(tree);
            tree = this.emptyNodeStripper.transformTree(tree);
            tree = this.xOverXRemover.transformTree(tree);
            return tree;
        }
    }

    public static class PunctuationNodeStripper
    implements TreeTransformer<String> {
        private static final Pattern punctuationPattern = Pattern.compile("\\W+");

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String label = tree.getLabel();
            Matcher matcher = punctuationPattern.matcher(label);
            if (matcher.matches()) {
                return null;
            }
            if (tree.isLeaf()) {
                return new Tree<String>(label);
            }
            List<Tree<String>> children = tree.getChildren();
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : children) {
                Tree<String> transformedChild = this.transformTree(child);
                if (transformedChild == null) continue;
                transformedChildren.add(transformedChild);
            }
            if (transformedChildren.size() == 0) {
                return null;
            }
            return new Tree<String>(label, transformedChildren);
        }
    }

    public static class XOverXRemover<E>
    implements TreeTransformer<E> {
        @Override
        public Tree<E> transformTree(Tree<E> tree) {
            E label = tree.getLabel();
            List<Tree<E>> children = tree.getChildren();
            while (children.size() == 1 && !children.get(0).isLeaf() && label.equals(children.get(0).getLabel())) {
                children = children.get(0).getChildren();
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<E> child : children) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<E>(label, transformedChildren);
        }
    }

    public static class EmptyNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String label = tree.getLabel();
            if (label.equals("-NONE-")) {
                return null;
            }
            if (tree.isLeaf()) {
                return new Tree<String>(label);
            }
            List<Tree<String>> children = tree.getChildren();
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : children) {
                Tree<String> transformedChild = this.transformTree(child);
                if (transformedChild == null) continue;
                transformedChildren.add(transformedChild);
            }
            if (transformedChildren.size() == 0) {
                return null;
            }
            return new Tree<String>(label, transformedChildren);
        }
    }

    public static class FunctionNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String transformedLabel = tree.getLabel();
            int cutIndex = transformedLabel.indexOf(45);
            int cutIndex2 = transformedLabel.indexOf(61);
            if (cutIndex2 > 0 && (cutIndex2 < cutIndex || cutIndex == -1)) {
                cutIndex = cutIndex2;
            }
            if (cutIndex > 0 && !tree.isLeaf()) {
                transformedLabel = new String(transformedLabel.substring(0, cutIndex));
            }
            if (tree.isLeaf()) {
                return new Tree<String>(transformedLabel);
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<String>(transformedLabel, transformedChildren);
        }
    }

    public static interface TreeTransformer<E> {
        public Tree<E> transformTree(Tree<E> var1);
    }
}

