/*
 * Decompiled with CFR 0.152.
 */
package pedi;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pedi.Individual;
import pedi.Pedigree;

public class SimplePedigree
implements Pedigree {
    private final Set<Individual> individuals = new HashSet<Individual>();
    private final Map<Individual, Individual> mother = new HashMap<Individual, Individual>();
    private final Map<Individual, Individual> father = new HashMap<Individual, Individual>();

    public SimplePedigree() {
    }

    public SimplePedigree(Pedigree p) {
        for (Individual i : p.individuals()) {
            for (int parentIdx = 0; parentIdx < 2; ++parentIdx) {
                Individual parent = p.parent(i, parentIdx);
                if (parent == null) continue;
                this.addRelation(parent, i, parentIdx);
            }
        }
    }

    private Map<Individual, Individual> getMap(int parentIndex) {
        return parentIndex == 0 ? this.father : this.mother;
    }

    @Override
    public Collection<Individual> individuals() {
        return this.individuals;
    }

    @Override
    public Individual parent(Individual i, int index) {
        return (index == 0 ? this.father : this.mother).get(i);
    }

    public void add(Individual individual) {
        this.individuals.add(individual);
    }

    public void addRelation(Individual parent, Individual child, int index) {
        this.individuals.add(parent);
        this.individuals.add(child);
        this.getMap(index).put(child, parent);
    }
}

