/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import pepper.Encodings;
import pepper.ICSILanguageModel;

public class PhonemeModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    private double[][] prs = null;
    private double discount;
    private double[][] discountedPrs = null;
    private final Encodings enc;
    private final ICSILanguageModel icsiLM;
    public static final int DEFAULT_MAX_LENGTH = 20;

    public Encodings getEncoding() {
        return this.enc;
    }

    public PhonemeModel(Encodings enc) {
        this.enc = enc;
        this.icsiLM = null;
    }

    public PhonemeModel(Encodings enc, ICSILanguageModel icsiLM) {
        this.icsiLM = icsiLM;
        this.enc = enc;
    }

    public PhonemeModel(Encodings enc, double[][] inPrs, boolean laplaceSmooth) {
        this.icsiLM = null;
        this.enc = enc;
        this.prs = new double[inPrs.length][inPrs[0].length];
        for (int c = 0; c < this.enc().getNumberOfEqClasses(); ++c) {
            for (int x = 0; x < this.enc().getNumberOfPhonemes(); ++x) {
                this.prs[c][x] = inPrs[c][x] + (laplaceSmooth ? 1.0 : 0.0);
            }
            NumUtils.normalize(this.prs[c]);
        }
        this.setDiscount(1.0);
    }

    public String generateFromBiGramPhonemeModel(Random rand) {
        return this.generateFromBiGramPhonemeModel(rand, 20);
    }

    public String generateFromBiGramPhonemeModel(Random rand, int maxLength) {
        StringBuilder result = new StringBuilder();
        char boundary = this.enc.phoneId2Char(this.enc.getBoundaryPhoneId());
        result.append(boundary);
        char cChar = boundary;
        do {
            int env = this.enc.char2EqClassId(result.charAt(result.length() - 1));
            int phonemeSampledId = SampleUtils.sampleMultinomial(rand, this.getProbs(env));
            cChar = result.length() > maxLength ? boundary : this.enc.phoneId2Char(phonemeSampledId);
            result.append(cChar);
        } while (cChar != boundary);
        String resultString = result.substring(1, result.length() - 1);
        assert (!resultString.contains("" + boundary));
        return resultString;
    }

    public double getLogProb(String s) {
        if (this.icsiLM != null) {
            return this.getICSILogProb(s);
        }
        double result = 0.0;
        for (int i = 0; i < s.length(); ++i) {
            int x = this.enc().char2PhoneId(s.charAt(i));
            int c1 = this.enc.topc(s, i - 1);
            result += Math.log(this.getProb(c1, x));
        }
        return result;
    }

    private double getICSILogProb(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            list.add("" + s.charAt(i));
        }
        return this.icsiLM.score(list);
    }

    private Encodings enc() {
        return this.enc;
    }

    public double getProb(int c1, int x) {
        return this.discountedPrs == null ? 1.0 / (double)this.enc.getNumberOfPhonemes() : this.discountedPrs[c1][x];
    }

    public double[] getProbs(int c1) {
        double[] prs = new double[this.enc.getNumberOfPhonemes()];
        for (int i = 0; i < this.enc.getNumberOfPhonemes(); ++i) {
            prs[i] = this.getProb(c1, i);
        }
        NumUtils.normalize(prs);
        return prs;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
        if (this.prs != null) {
            this.discountedPrs = new double[this.enc().getNumberOfEqClasses()][this.enc().getNumberOfPhonemes()];
            for (int c = 0; c < this.enc().getNumberOfEqClasses(); ++c) {
                for (int x = 0; x < this.enc().getNumberOfPhonemes(); ++x) {
                    this.discountedPrs[c][x] = Math.pow(this.prs[c][x], discount);
                }
            }
        }
    }

    public double getDiscount() {
        return this.discount;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int c = 0; c < this.enc().getNumberOfEqClasses(); ++c) {
            for (int x = 0; x < this.enc().getNumberOfPhonemes(); ++x) {
                result.append("" + this.enc().getEqClassDescription(c) + " " + this.enc().phoneId2Char(x) + " : " + this.getProb(c, x) + "\n");
            }
        }
        return result.toString();
    }
}

