/*
 * Decompiled with CFR 0.152.
 */
package practice;

import goblin.Taxon;
import java.util.List;
import nuts.util.CollUtils;
import org.jblas.DoubleMatrix;
import org.jblas.Singular;
import practice.Language;

public class ForestState {
    public double param;
    public int totalBranch = 0;
    private List<Language> genus;
    private RateMatrix Q;

    public ForestState(double param, RateMatrix Q, List<Language> trees) {
        this.param = param;
        this.Q = Q;
        this.genus = CollUtils.list();
        for (Language language : trees) {
            this.genus.add(language);
        }
    }

    public ForestState(ForestState current) {
        this(current.param, current.Q, current.genus);
        this.totalBranch = current.totalBranch;
    }

    public int nIterationLeft() {
        return this.genus.size() - 1;
    }

    public int numTrees() {
        return this.genus.size();
    }

    public double merge(int i0, int i1, int branch) {
        this.totalBranch += branch;
        Language l0 = this.genus.get(i0);
        Language l1 = this.genus.get(i1);
        double lik0 = l0.likelihood();
        double lik1 = l1.likelihood();
        Language lm = new Language(l0, l1, branch, this.totalBranch);
        lm.coalesce(this.Q);
        double likm = lm.likelihood();
        this.genus.set(i0, lm);
        double w = likm / (lik0 * lik1);
        this.genus.remove(i1);
        return w;
    }

    public String toString() {
        return this.genus.get(0).toString();
    }

    public static class RateMatrix {
        DoubleMatrix Q;
        DoubleMatrix U;
        DoubleMatrix D;
        DoubleMatrix V;
        public double mu = 1.0;

        public RateMatrix(int b) {
            double[][] tempQ = new double[b][b];
            for (int i = 0; i < b; ++i) {
                for (int j = 0; j < b; ++j) {
                    tempQ[i][j] = i == j ? -1.0 / (double)b : 1.0 / (double)b;
                }
            }
            this.Q = new DoubleMatrix(tempQ);
            DoubleMatrix[] svd = Singular.fullSVD((DoubleMatrix)this.Q);
            this.U = svd[0];
            this.D = svd[1];
            this.V = svd[2];
            for (int i = 0; i < this.D.rows; ++i) {
                this.D.put(i, Math.exp(this.D.get(i)));
            }
        }

        public DoubleMatrix computeCondProb(int branch) {
            DoubleMatrix P = DoubleMatrix.zeros((int)this.D.rows, (int)this.D.rows);
            double stay = 0.010416666666666666 + 0.9895833333333334 * Math.exp(-1.0 * (double)branch * this.mu);
            double sub = 0.010416666666666666 * (1.0 - Math.exp(-1.0 * (double)branch * this.mu));
            for (int i = 0; i < this.D.rows; ++i) {
                for (int j = 0; j < this.D.rows; ++j) {
                    if (i == j) {
                        P.put(i, j, stay);
                        continue;
                    }
                    P.put(i, j, sub);
                }
            }
            return P;
        }
    }

    public static class Tree {
        Taxon taxon;
        int[] obs;
        double[][] L;
        int numSounds;
        double likelihood = 0.0;
        Tree tl;
        Tree tr;
        int branch;
        public static double pi;

        public Tree() {
        }

        public Tree(Taxon taxon, int[] obs, int numSounds) {
            this.taxon = taxon;
            this.obs = obs;
            this.numSounds = numSounds;
            pi = 1.0 / (double)numSounds;
            this.L = new double[obs.length][numSounds];
            for (int p = 0; p < obs.length; ++p) {
                if (obs[p] == -1) {
                    for (int b = 0; b < numSounds; ++b) {
                        this.L[p][b] = 1.0 / (double)numSounds;
                    }
                    continue;
                }
                this.L[p][obs[p]] = pi;
            }
            this.likelihood = pi;
        }

        public String toString(int id) {
            StringBuilder sb = new StringBuilder();
            sb.append("(" + id + ")");
            for (int i = 0; i < this.branch; ++i) {
                sb.append("-");
            }
            sb.append(this.tl.toString(id + 1));
            sb.append(this.tr.toString(id + 2));
            return sb.toString();
        }

        public double likelihood() {
            return this.likelihood;
        }

        public void coalesce(Tree t0, Tree t1, RateMatrix Q, int branch) {
            this.L = t0.L;
            this.tl = t0;
            this.tr = t1;
            this.branch = branch;
            double condProb = 0.0;
            double l0 = 0.0;
            double l1 = 0.0;
            for (int p = 0; p < this.obs.length; ++p) {
                double lhood = 0.0;
                for (int z = 0; z < this.numSounds; ++z) {
                    for (int x = 0; x < this.numSounds; ++x) {
                        if (t0.L == null) {
                            l0 = t0.obs[p] == -1 ? condProb * pi : (x == t0.obs[p] ? condProb * pi : 0.0);
                            if (t1.obs[p] == -1) {
                                l1 = condProb * pi;
                                continue;
                            }
                            if (x == t1.obs[p]) {
                                l1 = condProb * pi;
                                continue;
                            }
                            l1 = 0.0;
                            continue;
                        }
                        l0 = condProb * t0.L[p][x];
                        l1 = condProb * t1.L[p][x];
                    }
                    this.L[p][z] = l0 * l1;
                    lhood += this.L[p][z] * pi;
                }
                if (lhood == 0.0) {
                    throw new RuntimeException("likelihood is 0");
                }
                this.likelihood *= lhood;
            }
        }
    }
}

