/*
 * Decompiled with CFR 0.152.
 */
package practice;

import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.Hashtable;
import java.util.List;
import nuts.util.CollUtils;
import practice.Language;

public class LanguagePair {
    public List<Pair<Language.Cognate, Language.Cognate>> cognates = CollUtils.list();
    public Hashtable<String, Double> alpha = new Hashtable();
    public Language l1;
    public Language l2;
    public double p;

    public LanguagePair(Language l1, Language l2) {
        this.l1 = l1;
        this.l2 = l2;
        this.p = 0.5;
    }

    public void addCognates(Language.Cognate c1, Language.Cognate c2) {
        this.cognates.add(new Pair<Language.Cognate, Language.Cognate>(c1, c2));
    }

    public int size() {
        return this.cognates.size();
    }

    public void update(double suff) {
        this.p = suff / (double)this.cognates.size();
    }

    public double getParam() {
        return this.p;
    }

    public void storeCw1w2(Language.Cognate c1, Language.Cognate c2, double p) {
        String key = c1.word + "_" + c2.word;
        this.alpha.put(key, p);
    }

    public double getCw1w2(Language.Cognate c1, Language.Cognate c2) {
        String key = c1.word + "_" + c2.word;
        if (!this.alpha.containsKey(key)) {
            LogInfo.logs("Error in storeCw1w2() because probability for two cognates " + key + " is not found.");
            System.exit(-1);
        }
        return this.alpha.get(key);
    }
}

