/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import java.io.File;
import pty.UnrootedTree;
import pty.io.TreeEvaluator;

public class CompareTrees {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("2 arguments required: [path to first newick file] [path to second newick file]");
            return;
        }
        UnrootedTree t1 = CompareTrees.parseTree(args[0]);
        UnrootedTree t2 = CompareTrees.parseTree(args[1]);
        if (t1 != null && t2 != null) {
            CompareTrees.printMetrics(t1, t2);
        }
    }

    private static void printMetrics(UnrootedTree t1, UnrootedTree t2) {
        if (!t1.leavesSet().equals(t2.leavesSet())) {
            System.err.println("Warning: sets of leaves not equal (" + t1.leavesSet() + " vs " + t2.leavesSet() + ")");
        }
        for (TreeEvaluator.TreeMetric m : TreeEvaluator.coreTreeMetrics) {
            System.out.println(m.toString() + "\t" + m.score(t1, t2));
        }
    }

    private static UnrootedTree parseTree(String string) {
        try {
            return UnrootedTree.fromNewick(new File(string));
        }
        catch (Exception e) {
            System.err.println("Error while parsing file " + string);
            System.err.println(e);
            return null;
        }
    }
}

