/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import fig.basic.Option;
import fig.prob.SampleUtils;
import goblin.Taxon;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import pty.ObservationDimensions;
import pty.io.Dataset;
import pty.learn.CTMCLoader;
import pty.smc.models.CTMC;
import pty.smc.models.CTMCUtils;

public class GeneratedDataset
implements Dataset {
    @Option
    public static int nSites = 100;
    @Option
    public static int depth = 4;
    @Option
    public static int evaluationDepth = 2;
    @Option
    public static Random rand = new Random(1L);
    public static CTMCLoader genCTMCLoader = new CTMCLoader();
    private CTMC ctmc = null;
    private Map<Taxon, int[]> generatedData = null;
    private Map<Taxon, String> populations = new HashMap<Taxon, String>();

    @Override
    public Map<Taxon, String> getReferenceClusters() {
        return Collections.unmodifiableMap(this.populations);
    }

    @Override
    public boolean hasReferenceClusters() {
        return true;
    }

    @Override
    public int nCharacter(int site) {
        this.init();
        return this.ctmc.nCharacter(site);
    }

    @Override
    public int nSites() {
        return nSites;
    }

    @Override
    public Map<Taxon, double[][]> observations() {
        this.init();
        return Dataset.DatasetUtils.convert(Collections.unmodifiableMap(this.generatedData), (ObservationDimensions)this);
    }

    private Map<Taxon, int[]> generate(CTMC model, int depth, Random rand) {
        if (depth <= 1) {
            throw new RuntimeException();
        }
        if (evaluationDepth > depth) {
            throw new RuntimeException();
        }
        HashMap<Taxon, int[]> result = new HashMap<Taxon, int[]>();
        int length = model.nSites();
        int[] root = new int[length];
        for (int i = 0; i < length; ++i) {
            root[i] = SampleUtils.sampleMultinomial(rand, model.getInitialDistribution(i));
        }
        for (int c = 0; c < 2; ++c) {
            this._generate(model, depth - 1, result, new Taxon("" + c), root, rand);
        }
        return result;
    }

    private Set<Taxon> _generate(CTMC model, int depth, Map<Taxon, int[]> result, Taxon curLang, int[] parent, Random rand) {
        HashSet<Taxon> leaves = new HashSet<Taxon>();
        int length = model.nSites();
        int[] cur = new int[length];
        for (int i = 0; i < length; ++i) {
            cur[i] = SampleUtils.sampleMultinomial(rand, model.getTransitionPr(i, 1.0)[parent[i]]);
        }
        if (depth == 1) {
            result.put(curLang, cur);
            leaves.add(curLang);
        } else {
            for (int c = 0; c < 2; ++c) {
                leaves.addAll(this._generate(model, depth - 1, result, new Taxon(curLang.toString() + c), cur, rand));
            }
        }
        if (evaluationDepth == depth) {
            for (Taxon lang : leaves) {
                this.populations.put(lang, "Pop" + curLang.toString());
            }
        }
        return leaves;
    }

    private void init() {
        if (this.ctmc != null) {
            return;
        }
        genCTMCLoader.setData(new Dataset(){

            @Override
            public Map<Taxon, String> getReferenceClusters() {
                throw new RuntimeException();
            }

            @Override
            public boolean hasReferenceClusters() {
                return false;
            }

            @Override
            public int nCharacter(int site) {
                throw new RuntimeException();
            }

            @Override
            public int nSites() {
                return nSites;
            }

            @Override
            public Map<Taxon, double[][]> observations() {
                throw new RuntimeException();
            }
        });
        this.ctmc = genCTMCLoader.load();
        CTMCUtils.saveInExec(this.ctmc, "generatingParams");
        this.generatedData = this.generate(this.ctmc, depth, rand);
    }
}

