/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.Pair;
import goblin.Taxon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.MathUtils;
import nuts.util.Tree;
import sage.ReadFreq;

public class DrawCladogram2
extends JApplet
implements Printable,
MouseListener,
KeyListener {
    private Tree<String> tree;
    private Map<String, Double> relativeBL = new HashMap<String, Double>();
    public static final int FONT_SIZE = 9;
    Map<Pair<Character, Character>, Color> colorMap = new HashMap<Pair<Character, Character>, Color>();
    Map<Taxon, List<ReadFreq.Line>> freqChange = new HashMap<Taxon, List<ReadFreq.Line>>();
    private Map<String, Integer> nDesc = new HashMap<String, Integer>();
    private double increment;
    private static final long serialVersionUID = 1L;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    private double base_x = 370.0;
    private double base_y = 300.0;
    private double zoom = 1.0;
    private Map<String, Shape> branches = new HashMap<String, Shape>();
    Point ptInit = null;

    public double getBranchLength(String node) {
        return 2.0 * this.relativeBL.get(node);
    }

    public static <T> Map<T, Integer> longestPathLengths(Tree<T> tree) {
        HashMap result = new HashMap();
        Arbre<T> a = Arbre.tree2Arbre(tree);
        for (Arbre<T> leave : a.leaves()) {
            DrawCladogram2._longestPathLengths(result, leave);
        }
        return result;
    }

    private static <T> void _longestPathLengths(Map<T, Integer> result, Arbre<T> leave) {
        int n = 0;
        Arbre<T> iterator = leave;
        while (!iterator.isRoot()) {
            ++n;
            iterator = iterator.getParent();
        }
        iterator = leave;
        while (!iterator.isRoot()) {
            Integer current = result.get(iterator.getContents());
            if (current == null) {
                result.put(iterator.getContents(), n);
            } else {
                result.put(iterator.getContents(), Math.max(current, n));
            }
            iterator = iterator.getParent();
        }
    }

    public static <T> Map<T, Double> assignRelativeBL(Tree<T> t, double rootBoost) {
        HashMap result = new HashMap();
        DrawCladogram2._assignRelativeBL(result, t, DrawCladogram2.longestPathLengths(t), 1.0, 0, rootBoost);
        return result;
    }

    private static <T> void _assignRelativeBL(Map<T, Double> result, Tree<T> t, Map<T, Integer> longestPathLengths, double lengthRemaining, int depth, double rootBoost) {
        for (Tree<T> child : t.getChildren()) {
            int pathL = longestPathLengths.get(child.getLabel());
            double length = lengthRemaining / (double)(pathL - depth) + rootBoost;
            result.put(child.getLabel(), length);
            DrawCladogram2._assignRelativeBL(result, child, longestPathLengths, lengthRemaining - length, depth + 1, 0.0);
        }
    }

    private int nDesc(Tree<String> t) {
        int n = 0;
        if (t.isLeaf()) {
            n = 1;
        } else {
            for (Tree<String> st : t.getChildren()) {
                n += this.nDesc(st);
            }
        }
        this.nDesc.put(t.getLabel(), n);
        return n;
    }

    @Override
    public void init() {
        throw new RuntimeException("Use DrawCladogram instead!");
    }

    private void computeExpBL(Tree<String> st, double d, double decay) {
        if (st.isLeaf()) {
            this.relativeBL.put(st.getLabel(), d);
        } else {
            this.relativeBL.put(st.getLabel(), d - d * decay);
            for (Tree<String> child : st.getChildren()) {
                this.computeExpBL(child, d * decay, decay);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.clearRect(0, 0, g2.getClipBounds().width, g2.getClipBounds().height);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(0.2f));
        g2.setFont(new Font("Dialog", 0, 9));
        g2.translate(this.base_x, this.base_y);
        g2.scale(this.zoom, this.zoom);
        this.paint(g2, this.tree, 0.0f, 0.0f, true);
    }

    private void paint(Graphics2D g, Tree<String> tree, float angleOffset, float branchOffset, boolean isRoot) {
        String current = tree.getLabel();
        double currentBL = 0.0;
        if (!isRoot) {
            currentBL = this.getBranchLength(current);
            Color initColor = g.getColor();
            this.setBranchColor(g, new Taxon(current));
            this.paintBranch(g, (double)angleOffset + (double)this.nDesc.get(current).intValue() * this.increment / 2.0, branchOffset, (float)currentBL, current);
            g.setColor(initColor);
        }
        if (tree.isLeaf()) {
            this.paintLeaf(g, (float)((double)branchOffset + currentBL), angleOffset + (float)this.increment / 2.0f, current);
        } else {
            int sizeOfFirst = this.nDesc.get(tree.getChildren().get(0).getLabel());
            int sizeOfLast = this.nDesc.get(tree.getChildren().get(tree.getChildren().size() - 1).getLabel());
            if (!isRoot) {
                double radius = (double)branchOffset + currentBL;
                this.paintArc(g, radius, (double)angleOffset + (double)sizeOfFirst * this.increment / 2.0, (double)angleOffset + ((double)this.nDesc.get(current).intValue() - (double)sizeOfLast / 2.0) * this.increment);
            }
            branchOffset = (float)((double)branchOffset + currentBL);
            for (Tree<String> st : tree.getChildren()) {
                this.paint(g, st, angleOffset, branchOffset, false);
                angleOffset = (float)((double)angleOffset + (double)this.nDesc.get(st.getLabel()).intValue() * this.increment);
            }
        }
    }

    private void setBranchColor(Graphics2D g, Taxon language) {
        List<ReadFreq.Line> ls = this.freqChange.get(language);
        if (ls == null || ls.size() == 0) {
            return;
        }
        Color c = this.colorMap.get(Pair.makePair(Character.valueOf(ls.get((int)0).left), Character.valueOf(ls.get((int)0).right)));
        if (c == null) {
            return;
        }
        g.setColor(c);
    }

    private void paintBranch(Graphics2D g, double angle, float branchOffset, float length, String name) {
        AffineTransform original = g.getTransform();
        g.rotate(angle);
        Line2D.Double line = new Line2D.Double(branchOffset, 0.0, branchOffset + length, 0.0);
        this.branches.put(name, g.getTransform().createTransformedShape(line));
        g.draw(line);
        g.setTransform(original);
    }

    private void paintArc(Graphics2D g, double radius, double angleStart, double angleEnd) {
        AffineTransform original = g.getTransform();
        g.scale(1.0, -1.0);
        angleStart = Math.toDegrees(angleStart);
        angleEnd = Math.toDegrees(angleEnd);
        g.draw(new Arc2D.Double(-radius, -radius, 2.0 * radius, 2.0 * radius, angleStart, angleEnd - angleStart, 0));
        g.setTransform(original);
    }

    private void paintLeaf(Graphics2D g, float circleRadius, float angle, String name) {
        circleRadius += 1.0f;
        AffineTransform original = g.getTransform();
        double proportion = (double)(angle = MathUtils.normalizeRad(angle)) / 2.0 / Math.PI;
        boolean flipped = proportion > 0.25 && proportion < 0.75;
        FontMetrics fm = g.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(name, g);
        float height = lm.getHeight();
        float width = fm.stringWidth(name);
        if (flipped) {
            g.rotate(angle);
            g.translate(circleRadius + width, (double)(-height) / 2.0);
            g.scale(-1.0, -1.0);
        } else {
            g.rotate(angle);
            g.translate(circleRadius, (double)height / 2.0);
        }
        AffineTransform at = g.getTransform();
        this.branches.put(name, at.createTransformedShape(new Rectangle2D.Double(0.0, -height, width, height)));
        Color initColor = g.getColor();
        this.setBranchColor(g, new Taxon(name));
        g.drawString(name, 0.0f, 0.0f);
        g.setColor(initColor);
        g.setTransform(original);
    }

    @Override
    public int print(Graphics graphics, PageFormat pagefmt, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        this.paint(graphics);
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.ptInit = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.ptInit == null) {
            return;
        }
        int x = Math.min(this.ptInit.x, e.getPoint().x);
        int y = Math.min(this.ptInit.y, e.getPoint().y);
        int w = Math.abs(this.ptInit.x - e.getPoint().x);
        int h = Math.abs(this.ptInit.y - e.getPoint().y);
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        for (String name : this.branches.keySet()) {
            if (!this.branches.get(name).intersects(r)) continue;
            Taxon lang = new Taxon(name);
            List<ReadFreq.Line> lines = this.freqChange.get(lang);
            for (ReadFreq.Line line : lines) {
                IO.so(line.summary());
            }
            IO.so("---");
        }
    }

    public static void main(String[] s) throws IOException {
        Frame f = new Frame("Phylogeny Inspector");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DrawCladogram2 applet = new DrawCladogram2();
        f.add("Center", applet);
        applet.init();
        f.pack();
        f.setSize(new Dimension(600, 600));
        f.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == 'h') {
            this.base_x += 30.0;
        }
        if (e.getKeyChar() == 'l') {
            this.base_x -= 30.0;
        }
        if (e.getKeyChar() == 'j') {
            this.base_y -= 30.0;
        }
        if (e.getKeyChar() == 'k') {
            this.base_y += 30.0;
        }
        if (e.getKeyChar() == 'z') {
            this.zoom *= 1.5;
        }
        if (e.getKeyChar() == 'r') {
            this.base_x = 300.0;
            this.base_y = 300.0;
            this.zoom = 1.0;
        }
        this.repaint();
    }
}

