/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.io.IOException;
import nuts.io.IO;
import scratch.EstimatePoisson;

public class EstimatePoissonBayes {
    public static void main(String[] args) throws IOException {
        double priorAlpha = 2.0;
        double priorBeta = 2.0;
        double N2 = 0.0;
        double sum = 0.0;
        double currentNaturalMAP = 0.0;
        for (String line : IO.i(args[0])) {
            double currentAlpha = priorAlpha + (sum += Double.parseDouble(line));
            double currentBeta = priorBeta + (N2 += 1.0);
            double currentMAP = EstimatePoissonBayes.modeGamma(currentAlpha, currentBeta);
            currentNaturalMAP = Math.log(currentMAP);
            if (!(N2 > 2000.0)) continue;
            break;
        }
        double bestNaturalMAP = currentNaturalMAP;
        N2 = 0.0;
        sum = 0.0;
        for (String line : IO.i(args[0])) {
            double currentAlpha = priorAlpha + (sum += Double.parseDouble(line));
            double currentBeta = priorBeta + (N2 += 1.0);
            double currentMAP = EstimatePoissonBayes.modeGamma(currentAlpha, currentBeta);
            currentNaturalMAP = Math.log(currentMAP);
            System.out.println("" + N2 + ", " + EstimatePoisson.poissonKL(bestNaturalMAP, currentNaturalMAP));
            if (!(N2 > 2000.0)) continue;
            break;
        }
    }

    public static double _modeGammaBadParam(double k, double theta) {
        if (k < 1.0) {
            return 0.0;
        }
        return (k - 1.0) * theta;
    }

    public static double modeGamma(double alpha, double beta) {
        double k = alpha;
        double theta = 1.0 / beta;
        return EstimatePoissonBayes._modeGammaBadParam(k, theta);
    }
}

