/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.io.Serializable;
import java.math.BigDecimal;
import scratch.Task;

public class Pi
implements Task<BigDecimal>,
Serializable {
    private static final long serialVersionUID = 227L;
    private static final BigDecimal FOUR = BigDecimal.valueOf(4L);
    private static final int roundingMode = 6;
    private final int digits;

    public Pi(int digits) {
        this.digits = digits;
    }

    @Override
    public BigDecimal execute() {
        return Pi.computePi(this.digits);
    }

    public static BigDecimal computePi(int digits) {
        int scale = digits + 5;
        BigDecimal arctan1_5 = Pi.arctan(5, scale);
        BigDecimal arctan1_239 = Pi.arctan(239, scale);
        BigDecimal pi = arctan1_5.multiply(FOUR).subtract(arctan1_239).multiply(FOUR);
        return pi.setScale(digits, 4);
    }

    public static BigDecimal arctan(int inverseX, int scale) {
        BigDecimal term;
        BigDecimal numer;
        BigDecimal invX = BigDecimal.valueOf(inverseX);
        BigDecimal invX2 = BigDecimal.valueOf(inverseX * inverseX);
        BigDecimal result = numer = BigDecimal.ONE.divide(invX, scale, 6);
        int i = 1;
        do {
            numer = numer.divide(invX2, scale, 6);
            int denom = 2 * i + 1;
            term = numer.divide(BigDecimal.valueOf(denom), scale, 6);
            result = i % 2 != 0 ? result.subtract(term) : result.add(term);
            ++i;
        } while (term.compareTo(BigDecimal.ZERO) != 0);
        return result;
    }
}

