/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import monaco.process.ResampleStatus;
import nuts.maxent.SloppyMath;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.EntangledRandom;
import smc.EntangledStructure;
import smc.Particle;
import smc.WeightCommunication;

public class EntangledParticle<S> {
    private ParticleAllocationStyle allocationStyle;
    private EntangledStructure<S> entangled;
    private EntangledRandom eRandom;
    private int numMachines;
    private int machineId;
    private int T;
    private int N;
    private ProcessSchedule schedule = null;

    public EntangledParticle(ParticleKernel<S> kernel, ParticleFilter.ParticleProcessor<S> processor, EntangledRandom eRandom, int machineId, int T, int[] capacity, int totalNumParticles, ParticleAllocationStyle allocationStyle) {
        this.entangled = new EntangledStructure<S>(machineId, totalNumParticles, T, kernel, capacity, processor);
        this.eRandom = eRandom;
        this.numMachines = capacity.length;
        this.machineId = machineId;
        this.T = T;
        this.N = totalNumParticles;
        this.allocationStyle = allocationStyle;
        WeightCommunication.numNodes = this.numMachines;
        Particle.numMachines = this.numMachines;
    }

    public static <S> EntangledParticle<S> run(ParticleKernel<S> kernel, ParticleFilter.ParticleProcessor<S> processor, EntangledRandom eRandom, int machineId, int[][] config, int totalNumParticles, ParticleAllocationStyle allocationStyle, ProcessSchedule schedule) {
        int T = kernel.nIterationsLeft(kernel.getInitial());
        EntangledParticle<S> ep = new EntangledParticle<S>(kernel, processor, eRandom, machineId, T, config[1], totalNumParticles, allocationStyle);
        super.setSchedule(schedule);
        ep.start(config[0]);
        return ep;
    }

    private void setSchedule(ProcessSchedule schedule) {
        this.schedule = schedule;
    }

    public void start(int[] config) {
        LogInfo.logs("Starting entangled particle...");
        double[] weights = null;
        double[] allWeights = new double[this.N];
        double norm = 0.0;
        for (int t = 0; t < this.T; ++t) {
            LogInfo.logs("t=" + t);
            weights = this.entangled.generateSampleAndComputeWeights(t, config, this.eRandom, this.schedule);
            try {
                WeightCommunication.writeWeights(weights, t, this.machineId);
                norm = this.entangled.readWeights(t, config, allWeights);
            }
            catch (IOException ex) {
                LogInfo.logs("Unrecoverable error: Unable to write weights for machine=" + this.machineId + " at t=" + t);
                System.exit(-1);
            }
            catch (WeightCommunication.WeightTimeoutException wex) {
                LogInfo.logs("Unrecoverable error: " + wex.toString());
                System.exit(-1);
            }
            norm = SloppyMath.logAdd(allWeights);
            for (int n = 0; n < allWeights.length; ++n) {
                allWeights[n] = allWeights[n] - norm;
                allWeights[n] = Math.exp(allWeights[n]);
                this.entangled.setWeight(n, allWeights[n]);
            }
            if (this.schedule != null && this.schedule.shouldProcess(new ProcessScheduleContext(t, t == this.T - 1, ResampleStatus.NA))) {
                this.entangled.distributedProcess();
            }
            Counter<Integer> resampled = this.eRandom.efficientResample(allWeights);
            this.printResampled(resampled);
            config = this.optimizeAndReconstruct(resampled);
            if (this.schedule == null) continue;
            this.schedule.monitor(new ProcessScheduleContext(t, t == this.T - 1, ResampleStatus.NA));
        }
        ArrayList<Double> w = CollUtils.list();
        for (int i = 0; i < allWeights.length; ++i) {
            w.add(allWeights[i]);
        }
        Collections.sort(w);
        this.printWeights(w);
    }

    private int[] optimizeAndReconstruct(Counter<Integer> resampled) {
        int[] config = new int[this.numMachines];
        int n = 0;
        while ((double)n < resampled.totalCount()) {
            double count = resampled.getCount(n);
            if (count == 0.0) {
                this.entangled.remove(n);
            } else {
                int j = 0;
                while ((double)j < count) {
                    if (this.allocationStyle == ParticleAllocationStyle.RANDOM) {
                        this.entangled.allocateRandomly(n, config, this.eRandom);
                    } else if (this.allocationStyle == ParticleAllocationStyle.FIRST_OPEN) {
                        this.entangled.allocateFirstOpen(n, config);
                    } else if (this.allocationStyle == ParticleAllocationStyle.MOST_AVAILABLE) {
                        this.entangled.allocateMostAvailable(n, config);
                    } else if (this.allocationStyle == ParticleAllocationStyle.RETAIN_RANDOM) {
                        this.entangled.allocateRetainRandom(n, config, this.eRandom);
                    }
                    ++j;
                }
            }
            ++n;
        }
        this.printParticleAllocation(config);
        return config;
    }

    private int[] optimizeAndReconstruct(int[] resampled) {
        int[] config = new int[this.numMachines];
        for (int n = 0; n < resampled.length; ++n) {
            if (resampled[n] == 0) {
                this.entangled.remove(n);
                continue;
            }
            for (int j = 0; j < resampled[n]; ++j) {
                if (this.allocationStyle == ParticleAllocationStyle.RANDOM) {
                    this.entangled.allocateRandomly(n, config, this.eRandom);
                    continue;
                }
                if (this.allocationStyle == ParticleAllocationStyle.FIRST_OPEN) {
                    this.entangled.allocateFirstOpen(n, config);
                    continue;
                }
                if (this.allocationStyle == ParticleAllocationStyle.MOST_AVAILABLE) {
                    this.entangled.allocateMostAvailable(n, config);
                    continue;
                }
                if (this.allocationStyle != ParticleAllocationStyle.RETAIN_RANDOM) continue;
                this.entangled.allocateRetainRandom(n, config, this.eRandom);
            }
        }
        this.printParticleAllocation(config);
        return config;
    }

    public void printStatistics() {
        this.entangled.printStatistics();
    }

    private void printParticleAllocation(int[] config) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < config.length; ++i) {
            sb.append(config[i] + " ");
        }
        LogInfo.logs(sb.toString());
    }

    private void printResampled(Counter<Integer> resampled) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((double)i < resampled.totalCount()) {
            if (resampled.getCount(i) > 0.0) {
                sb.append(i + ":" + resampled.getCount(i) + " ");
            }
            ++i;
        }
        LogInfo.logs(sb.toString());
    }

    private void printWeights(ArrayList<Double> weights) {
        StringBuffer sb = new StringBuffer();
        for (Double w : weights) {
            sb.append(w + " ");
        }
        LogInfo.logs(sb.toString());
    }

    public static enum ParticleAllocationStyle {
        FIRST_OPEN,
        RANDOM,
        MOST_AVAILABLE,
        RETAIN_RANDOM;

    }
}

