/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import smc.Model;
import smc.RandomGenerator;
import smc.SMC;

public class TestSMC
implements Runnable {
    @Option(required=true)
    public double varOne;
    @Option(required=true)
    public double varV;
    @Option(required=true)
    public double varW;
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int T;

    public static void main(String[] args) {
        IO.run(args, new TestSMC());
    }

    @Override
    public void run() {
        double[][] obs = this.generateHMMObservations();
        ToyModel model = new ToyModel(this.varV, this.varW, this.varOne, obs[1]);
        SMC<Double> smc = SMC.runSMC(this.T, this.N, model);
        double[] estimates = new double[this.T];
        for (int t = 0; t < this.T; ++t) {
            for (int n = 0; n < this.N; ++n) {
                SMC.Particle<Double> p = smc.getParticle(t, n);
                int n2 = t;
                estimates[n2] = estimates[n2] + (Double)p.sample;
            }
            LogInfo.logs("Estimate=" + estimates[t] / (double)this.N + " Actual=" + obs[0][t]);
        }
    }

    private double[][] generateHMMObservations() {
        Random rand = new Random();
        double[][] obs = new double[2][this.T];
        obs[0][0] = RandomGenerator.generateNormal(rand.nextLong(), 0.0, 5.0);
        double rw = RandomGenerator.generateNormal(rand.nextLong(), 0.0, this.varW);
        obs[1][0] = Math.pow(obs[0][0], 2.0) / 20.0 + rw;
        double rv = 0.0;
        rw = 0.0;
        for (int t = 1; t < this.T; ++t) {
            double x_prev = obs[0][t - 1];
            rv = RandomGenerator.generateNormal(rand.nextLong(), 0.0, this.varV);
            obs[0][t] = x_prev / 2.0 + 25.0 * x_prev / (1.0 + Math.pow(x_prev, 2.0)) + 8.0 * Math.cos(1.2 * (double)t) + rv;
            rw = RandomGenerator.generateNormal(rand.nextLong(), 0.0, this.varW);
            obs[1][t] = Math.pow(obs[0][t], 2.0) / 20.0 + rw;
        }
        return obs;
    }

    public static class ToyModel
    implements Model<Double> {
        public static double vConst;
        public static double wConst;
        public static double var1Const;
        public double varV;
        public double varW;
        public double varOne;
        public double[] observations;

        public ToyModel(double varV, double varW, double varOne, double[] obs) {
            vConst = 1.0 / Math.sqrt(Math.PI * 2 * varV);
            wConst = 1.0 / Math.sqrt(Math.PI * 2 * varW);
            var1Const = 1.0 / Math.sqrt(Math.PI * 2 * varOne);
            this.varV = varV;
            this.varW = varW;
            this.varOne = varOne;
            this.observations = obs;
        }

        @Override
        public Double generateSample(long seed, int t, List<Double> xprev) {
            double x_t = 0.0;
            if (t == 0) {
                x_t = RandomGenerator.generateNormal(seed, 0.0, this.varOne);
            } else {
                double x = xprev.get(t - 1);
                x_t = x / 2.0 + 25.0 * x / (1.0 + Math.pow(x, 2.0)) + 8.0 * Math.cos(1.2 * (double)t);
                x_t += RandomGenerator.generateNormal(seed, 0.0, this.varV);
            }
            return new Double(x_t);
        }

        @Override
        public double evaluateWeight(int t, List<Double> xprev, Double xcurr) {
            double x = xcurr;
            double retval = wConst * Math.exp(-Math.pow(this.observations[t] - Math.pow(x, 2.0) / 20.0, 2.0) / (2.0 * this.varW));
            return retval;
        }
    }
}

