/*
 * Decompiled with CFR 0.152.
 */
package stat560;

import JSci.maths.statistics.NormalDistribution;
import Jama.Matrix;
import java.util.Random;
import nuts.math.Sampling;

public class CI {
    public static void main(String[] args) {
        Random rand = new Random(1L);
        double rate = 1.0;
        double nData = 10000.0;
        double analytic = 1.0;
        double nRep = 1000.0;
        double nCorrect = 0.0;
        int rep = 0;
        while ((double)rep < nRep) {
            double mean;
            Matrix s;
            double m1 = 0.0;
            double m2 = 0.0;
            double m3 = 0.0;
            double m4 = 0.0;
            int dataIdx = 0;
            while ((double)dataIdx < nData) {
                double x = Sampling.sampleExponential(rand, 1.0 / rate);
                m1 += x;
                m2 += x * x;
                m3 += x * x * x;
                m4 += x * x * x * x;
                ++dataIdx;
            }
            m1 /= nData;
            m2 /= nData;
            m3 /= nData;
            m4 /= nData;
            Matrix g = new Matrix(CI.g(m1, m2), 1);
            Matrix _var = g.times(s = new Matrix(CI.covar(m1, m2, m3, m4))).times(g.transpose());
            double var = _var.get(0, 0);
            double[] ci = CI.ci(0.95, nData, var, mean = Math.sqrt(m2 - m1 * m1) / m1);
            if (ci[0] <= analytic && ci[1] >= analytic) {
                nCorrect += 1.0;
            }
            ++rep;
        }
        System.out.println("Coverage = " + nCorrect / nRep);
    }

    public static double[] ci(double alpha, double n, double var, double mean) {
        double z_alpha = new NormalDistribution().inverse(1.0 - alpha);
        double z_one_minus_alpha = new NormalDistribution().inverse(alpha);
        return new double[]{mean - Math.sqrt(var) * z_one_minus_alpha / Math.sqrt(n), mean - Math.sqrt(var) * z_alpha / Math.sqrt(n)};
    }

    public static double[] g(double m1, double m2) {
        return new double[]{-m2 / (m1 * m1 * Math.sqrt(m2 - m1 * m1)), 1.0 / (2.0 * m1 * Math.sqrt(m2 - m1 * m1))};
    }

    public static double[][] covar(double m1, double m2, double m3, double m4) {
        return new double[][]{{m2 - m1 * m1, m3 - m1 * m2}, {m3 - m1 * m2, m4 - m2 * m2}};
    }
}

