/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoXRef;

public class BasicGoXRef
implements GoXRef {
    private final String _xref;
    private final GoXRef.Type _type;

    public BasicGoXRef(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("unexpected format for GO xref: " + string);
        }
        String string2 = stringArray[0].trim();
        if (string2.equals("EC")) {
            this._type = GoXRef.Type.EC;
        } else if (string2.equals("MetaCyc")) {
            this._type = GoXRef.Type.META_CYC;
        } else if (string2.equals("Reactome")) {
            this._type = GoXRef.Type.REACTOME;
        } else if (string2.equals("RESID")) {
            this._type = GoXRef.Type.RESID;
        } else if (string2.equals("UM-BBD_enzymeID")) {
            this._type = GoXRef.Type.UM_BBD_ENZYME_ID;
        } else if (string2.equals("UM-BBD_pathwayID")) {
            this._type = GoXRef.Type.UM_BBD_PATHWAY_ID;
        } else if (string2.equals("UM-BBD_reactionID")) {
            this._type = GoXRef.Type.UM_BBD_REACTIONID;
        } else if (string2.equals("TC")) {
            this._type = GoXRef.Type.TC;
        } else if (string2.equals("AraCyc")) {
            this._type = GoXRef.Type.ARACYC;
        } else if (string2.equals("XX")) {
            this._type = GoXRef.Type.XX;
        } else if (string2.equals("PMID")) {
            this._type = GoXRef.Type.PMID;
        } else if (string2.equals("IMG")) {
            this._type = GoXRef.Type.IMG;
        } else if (string2.equals("GOC")) {
            this._type = GoXRef.Type.GOC;
        } else if (string2.equals("KEGG")) {
            this._type = GoXRef.Type.KEGG;
        } else if (string2.equals("Wikipedia")) {
            this._type = GoXRef.Type.WIKIPEDIA;
        } else if (string2.equals("RHEA")) {
            this._type = GoXRef.Type.RHEA;
        } else if (string2.equals("NIF_Subcellular")) {
            this._type = GoXRef.Type.NIF_SUBCELLULAR;
        } else if (string2.equals("CORUM")) {
            this._type = GoXRef.Type.CORUM;
        } else if (string2.equals("UniPathway")) {
            this._type = GoXRef.Type.UNIPATHWAY;
        } else if (string2.equals("PO")) {
            this._type = GoXRef.Type.PO;
        } else if (string2.equals("SABIO-RK")) {
            this._type = GoXRef.Type.SABIO_RK;
        } else {
            throw new IllegalArgumentException("unknown GO xref type: " + string2);
        }
        this._xref = stringArray[1].trim();
    }

    public BasicGoXRef(GoXRef.Type type, String string) {
        this._type = type;
        this._xref = string;
    }

    @Override
    public int compareTo(GoXRef goXRef) {
        return this.getXRef().compareTo(goXRef.getXRef());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go xref equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go xref equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getXRef().equals(((GoXRef)object).getXRef()) && this.getType().equals((Object)((GoXRef)object).getType());
    }

    @Override
    public GoXRef.Type getType() {
        return this._type;
    }

    @Override
    public String getXRef() {
        return this._xref;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case EC: {
                stringBuffer.append("EC");
                break;
            }
            case META_CYC: {
                stringBuffer.append("MetaCyc");
                break;
            }
            case REACTOME: {
                stringBuffer.append("Reactome");
                break;
            }
            case RESID: {
                stringBuffer.append("RESID");
                break;
            }
            case UM_BBD_ENZYME_ID: {
                stringBuffer.append("UM-BBD_enzymeID");
                break;
            }
            case UM_BBD_PATHWAY_ID: {
                stringBuffer.append("UM-BBD_pathwayID");
                break;
            }
            case UM_BBD_REACTIONID: {
                stringBuffer.append("UM-BBD_reactionID");
                break;
            }
            case TC: {
                stringBuffer.append("TC");
                break;
            }
            case ARACYC: {
                stringBuffer.append("AraCyc");
                break;
            }
            case XX: {
                stringBuffer.append("XX");
                break;
            }
            case GOC: {
                stringBuffer.append("GOC");
                break;
            }
            case IMG: {
                stringBuffer.append("IMG");
                break;
            }
            case PMID: {
                stringBuffer.append("PMID");
                break;
            }
            case WIKIPEDIA: {
                stringBuffer.append("Wikipedia");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        stringBuffer.append(":");
        stringBuffer.append(this.getXRef());
        return stringBuffer.toString();
    }
}

